(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    399436,       7071]
NotebookOptionsPosition[    388802,       6912]
NotebookOutlinePosition[    389284,       6929]
CellTagsIndexPosition[    389241,       6926]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", "definiciones", "*)"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"41c6103b-0af5-44a6-8576-9ed0ee7275c3"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"unidades", ":", " ", "m"}], ",", " ", "N"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.801121643941407*^9, 3.801121660352407*^9}, 
   3.8248827740607753`*^9, 3.8421788839209356`*^9},
 CellLabel->"In[2]:=",ExpressionUUID->"5e6da543-c560-4ce5-b12c-3daa8af914d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"matriz", " ", "de", " ", 
     RowBox[{"paso", ":", " ", "globales"}]}], " ", "->", " ", "locales"}], 
   "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "y"}], ",", "x", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\n", "\t\t", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "x", ",", "y", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{"-", "y"}], ",", "x", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1"}], 
        "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"T", "[", 
     RowBox[{
      SubscriptBox["\[Lambda]", "X"], ",", 
      SubscriptBox["\[Lambda]", "Y"]}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"d81600bd-def5-4563-a79c-10ed3fa32b9c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      SubscriptBox["\[Lambda]", "X"], 
      SubscriptBox["\[Lambda]", "Y"], "0", "0", "0", "0"},
     {
      RowBox[{"-", 
       SubscriptBox["\[Lambda]", "Y"]}], 
      SubscriptBox["\[Lambda]", "X"], "0", "0", "0", "0"},
     {"0", "0", "1", "0", "0", "0"},
     {"0", "0", "0", 
      SubscriptBox["\[Lambda]", "X"], 
      SubscriptBox["\[Lambda]", "Y"], "0"},
     {"0", "0", "0", 
      RowBox[{"-", 
       SubscriptBox["\[Lambda]", "Y"]}], 
      SubscriptBox["\[Lambda]", "X"], "0"},
     {"0", "0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.842246174202918*^9, 3.8422477725780115`*^9, {3.842248057921551*^9, 
   3.8422480800935307`*^9}, 3.8422487970934353`*^9, 3.8422513133594313`*^9, 
   3.8422519763280582`*^9, 3.842252995515604*^9, {3.8422545940155087`*^9, 
   3.842254608905939*^9}, 3.84225466156223*^9, 3.842266813484243*^9, 
   3.8422669867809954`*^9, {3.8422670428748875`*^9, 3.8422670588436055`*^9}, 
   3.8422699318435664`*^9, 3.8422706104215837`*^9, 3.8422709361403093`*^9, 
   3.8422709769372067`*^9, {3.8422712258751307`*^9, 3.8422712493278723`*^9}, 
   3.8422776935467653`*^9, 3.8423196610457363`*^9, 3.8423197151934824`*^9, 
   3.8423238516160593`*^9, 3.8423609872197523`*^9, 3.8423614477822156`*^9, {
   3.842362424141717*^9, 3.8423624428606687`*^9}, 3.8423672074230824`*^9, 
   3.8423673343920546`*^9, 3.84236820850111*^9, 3.8424068343633165`*^9, 
   3.842407100953713*^9, 3.8424105359772873`*^9, {3.842410592154978*^9, 
   3.842410613666727*^9}, 3.8424107703342485`*^9, 3.842411268080553*^9, 
   3.842411708204101*^9, {3.8424242386345315`*^9, 3.8424242473999467`*^9}, {
   3.8424244904312077`*^9, 3.842424512478091*^9}, 3.842444433196889*^9, 
   3.842444845118881*^9, 3.842444880587491*^9, 3.842444916306244*^9, 
   3.8424450747126913`*^9, 3.8424451655876427`*^9, {3.842445204103305*^9, 
   3.8424452219158735`*^9}, 3.8424452538374767`*^9, 3.84244535200953*^9, 
   3.8424454047282495`*^9, 3.842445463900259*^9, 3.8424457755252447`*^9, 
   3.8424467447749147`*^9, 3.842447328556199*^9, 3.8424476495874867`*^9, 
   3.842447929618958*^9, 3.8424479741656904`*^9, 3.842448183681241*^9, 
   3.842448288915736*^9, {3.8424483820406055`*^9, 3.842448400837759*^9}, {
   3.842448678103158*^9, 3.842448695290681*^9}, 3.8424489438846464`*^9, 
   3.842449095337822*^9, 3.8424492303532686`*^9, {3.842449315634308*^9, 
   3.8424493328217936`*^9}, 3.8424494238689656`*^9, 3.8424495088687887`*^9, 
   3.8425722389373574`*^9, {3.8425723194997616`*^9, 3.8425723482032595`*^9}, 
   3.8425725075155754`*^9, 3.8425726203122206`*^9, {3.8425727252654715`*^9, 
   3.8425727509689417`*^9}, {3.842572990968835*^9, 3.842573018015401*^9}, {
   3.8425784537928143`*^9, 3.8425784725560226`*^9}, 3.8425787498147535`*^9, 
   3.8425788000523605`*^9, 3.8425790474263687`*^9, 3.8425810471420603`*^9, {
   3.8425823295353947`*^9, 3.842582350746126*^9}, 3.8425824907674255`*^9, 
   3.842582536083327*^9, 3.8425832915327983`*^9, 3.8425833792661505`*^9, 
   3.8425834760057516`*^9, {3.8425835365307117`*^9, 3.84258355442381*^9}, {
   3.8425837631173925`*^9, 3.8425837726909485`*^9}, {3.8425838111647873`*^9, 
   3.842583837015785*^9}, 3.842583879512142*^9, {3.8425840580924473`*^9, 
   3.8425840723013325`*^9}, 3.8425842616984415`*^9, {3.842584355800496*^9, 
   3.842584375906705*^9}, 3.842584597862932*^9, 3.8425847118869514`*^9, 
   3.8425849144926977`*^9, 3.8425849519170847`*^9, 3.8425850862575827`*^9, {
   3.84258518217087*^9, 3.842585196586887*^9}, 3.8425913360128164`*^9, 
   3.842591465232932*^9, 3.842591609633464*^9},
 CellLabel->
  "Out[4]//MatrixForm=",ExpressionUUID->"8398e883-fa7e-42d3-b20c-\
7834c60b20cd"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8421788130458455`*^9, 3.842178826108324*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"37688275-b3f9-455e-b8b5-a17dcb797872"],

Cell[BoxData[
 RowBox[{
  RowBox[{"datos", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"L0", "\[Rule]", "5.0"}], ",", 
     RowBox[{"vE", "\[Rule]", 
      RowBox[{"2.1", " ", 
       RowBox[{"10", "^", "11"}]}]}], ",", 
     RowBox[{"A", "\[Rule]", 
      RowBox[{
       RowBox[{"10", "^", "12"}], " ", "53.8", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "4"}]}]}]}], ",", " ", 
     RowBox[{"Iy", "\[Rule]", 
      RowBox[{"8360.0", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "8"}]}]}]}], ",", 
     RowBox[{"Sy", "\[Rule]", 
      RowBox[{"628", " ", 
       RowBox[{"10", "^", 
        RowBox[{"-", "6"}]}]}]}], ",", 
     RowBox[{"fy", "\[Rule]", 
      RowBox[{"275.0", " ", 
       RowBox[{"10", "^", "6"}]}]}], ",", 
     RowBox[{"Mp", "->", 
      RowBox[{"Sy", " ", "fy"}]}], ",", 
     RowBox[{"Np", "\[Rule]", 
      RowBox[{"A", " ", "fy"}]}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.824882757110754*^9, 3.824882793440569*^9}, {
   3.8248829239206715`*^9, 3.8248829904071894`*^9}, {3.824884903288989*^9, 
   3.824884908479391*^9}, {3.824886114432556*^9, 3.8248861164882784`*^9}, {
   3.824886237738434*^9, 3.82488623788818*^9}, {3.8248862796083403`*^9, 
   3.8248862809098988`*^9}, {3.8248863241981044`*^9, 3.8248863563668427`*^9}, 
   3.8248863885583096`*^9, 3.82488643533702*^9, {3.824886490568218*^9, 
   3.8248864906282115`*^9}, {3.8249010749895525`*^9, 
   3.8249010772239017`*^9}, {3.824967447597184*^9, 3.8249674644252486`*^9}, {
   3.824973570846686*^9, 3.824973570987552*^9}, {3.824977726831568*^9, 
   3.824977741425001*^9}, {3.8249778722531233`*^9, 3.824977878815629*^9}, {
   3.824977951753088*^9, 3.824977954378475*^9}, {3.824990126351965*^9, 
   3.8249901356751966`*^9}, {3.824990267065647*^9, 3.824990270675438*^9}, {
   3.824990537690506*^9, 3.824990571690587*^9}, {3.824990721409603*^9, 
   3.8249907236753826`*^9}, {3.824990779722327*^9, 3.824990782456306*^9}, {
   3.824990835378228*^9, 3.824990851440775*^9}, {3.8249909035031357`*^9, 
   3.8249911147064495`*^9}, {3.824991724706246*^9, 3.8249917274875298`*^9}, {
   3.8249917662687483`*^9, 3.8249917691906557`*^9}, {3.8297433880254717`*^9, 
   3.8297433907114058`*^9}, {3.8297436137268906`*^9, 
   3.8297436138050117`*^9}, {3.829743687331747*^9, 3.8297437052269583`*^9}, {
   3.829743742258331*^9, 3.8297437636019382`*^9}, {3.8297438203489227`*^9, 
   3.8297438266957293`*^9}, {3.8297439234614058`*^9, 
   3.8297439259923563`*^9}, {3.829743988180004*^9, 3.829743990851763*^9}, {
   3.829744027445855*^9, 3.829744052242682*^9}, {3.8297441596490073`*^9, 
   3.8297441621925535`*^9}, {3.8297597420864816`*^9, 3.829759745086625*^9}, {
   3.829759812101802*^9, 3.829759815836361*^9}, {3.829759872711401*^9, 
   3.829759873992738*^9}, {3.8297864397426047`*^9, 3.8297864443988285`*^9}, {
   3.8297864987311525`*^9, 3.829786502476842*^9}, {3.829786554290691*^9, 
   3.829786598726751*^9}, {3.8297869071021013`*^9, 3.8297869072426395`*^9}, {
   3.8297952874112787`*^9, 3.829795290285303*^9}, {3.829795542458662*^9, 
   3.8297955490394325`*^9}, {3.829796859992366*^9, 3.8297968615552287`*^9}, {
   3.829863317708397*^9, 3.829863320854826*^9}, {3.8298633816856337`*^9, 
   3.829863385604924*^9}, {3.82986345215166*^9, 3.8298634533864336`*^9}, {
   3.82998219756022*^9, 3.829982200326254*^9}, {3.8299823367635875`*^9, 
   3.8299823412008133`*^9}, {3.829982541653951*^9, 3.8299825457008305`*^9}, {
   3.8300552216667023`*^9, 3.8300552241854496`*^9}, {3.8300555488574324`*^9, 
   3.830055557029495*^9}, {3.8300556126283903`*^9, 3.8300556161852446`*^9}, {
   3.8300556622635713`*^9, 3.8300556642791758`*^9}, {3.8310050642862873`*^9, 
   3.831005078986656*^9}, {3.8310052102364807`*^9, 3.8310052135965557`*^9}, {
   3.8310053191665773`*^9, 3.8310053232463183`*^9}, {3.8310054825218267`*^9, 
   3.831005485196499*^9}, {3.8388829753803687`*^9, 3.83888297917702*^9}, {
   3.8388830565439396`*^9, 3.8388830658722734`*^9}, {3.8388831371616774`*^9, 
   3.8388831393756886`*^9}, {3.838883316708358*^9, 3.838883321286459*^9}, {
   3.838883926087798*^9, 3.838883964927043*^9}, {3.8388841060833735`*^9, 
   3.8388841089738336`*^9}, {3.838884414394975*^9, 3.8388844208907285`*^9}, {
   3.838884466895975*^9, 3.838884469411621*^9}, {3.838884614496914*^9, 
   3.8388846262396517`*^9}, {3.838885295194275*^9, 3.8388853077552576`*^9}, {
   3.8388853518497653`*^9, 3.838885409208555*^9}, {3.838885450773469*^9, 
   3.838885484395789*^9}, {3.8388855186678624`*^9, 3.8388855454228296`*^9}, {
   3.838885581145263*^9, 3.8388855839284763`*^9}, {3.8395970969997964`*^9, 
   3.8395971381836615`*^9}, {3.8395976880593414`*^9, 3.839597699043829*^9}, {
   3.8395977359132347`*^9, 3.8395977382465253`*^9}, {3.839597817049427*^9, 
   3.8395978176904716`*^9}, {3.8395979003040333`*^9, 
   3.8395979003801723`*^9}, {3.839598123763075*^9, 3.8395981332638006`*^9}, {
   3.839598163717794*^9, 3.8395981659060636`*^9}, {3.8395983160083814`*^9, 
   3.839598320232024*^9}, {3.8395983563117657`*^9, 3.8395984282517424`*^9}, {
   3.839598519590248*^9, 3.839598524484462*^9}, {3.8395986007854223`*^9, 
   3.839598614798439*^9}, {3.8395989098820534`*^9, 3.8395989345062075`*^9}, {
   3.839599172592599*^9, 3.8395992007822695`*^9}, 3.839599306048252*^9, {
   3.8395998624099607`*^9, 3.839599865500718*^9}, {3.8395999159839954`*^9, 
   3.839599946765421*^9}, {3.839601128926681*^9, 3.839601129035734*^9}, 
   3.8396012184012823`*^9, 3.8396016080134945`*^9, 3.8396016929601107`*^9, 
   3.8396017910269294`*^9, {3.839601848417593*^9, 3.839601976995034*^9}, 
   3.839602645685421*^9, {3.8396393432754927`*^9, 3.8396393514344215`*^9}, 
   3.839639832906049*^9, {3.83963987225074*^9, 3.839639897686414*^9}, {
   3.839645239045117*^9, 3.839645242016185*^9}, {3.8396453194784284`*^9, 
   3.8396453219712515`*^9}, {3.8396453999135237`*^9, 
   3.8396454248009973`*^9}, {3.83964551485489*^9, 3.839645526957655*^9}, {
   3.8396456021413865`*^9, 3.8396456335301647`*^9}, {3.8396456687197886`*^9, 
   3.8396456878191833`*^9}, 3.839729209626177*^9, {3.8397296656837893`*^9, 
   3.839729668436919*^9}, {3.8397297094777327`*^9, 3.8397297526804385`*^9}, {
   3.8398596286960983`*^9, 3.8398596288407135`*^9}, {3.8398598361574693`*^9, 
   3.839859884417356*^9}, {3.8399427110370517`*^9, 3.8399427134895496`*^9}, {
   3.8399427726459956`*^9, 3.8399428070991125`*^9}, {3.839943014263241*^9, 
   3.8399430173535833`*^9}, {3.8399430497868996`*^9, 
   3.8399431016613455`*^9}, {3.8399431383685207`*^9, 3.8399431386458*^9}, {
   3.839943196974179*^9, 3.8399432340414076`*^9}, 3.839943272333488*^9, {
   3.840250965268117*^9, 3.840250968455263*^9}, {3.840251817064988*^9, 
   3.8402518277688627`*^9}, {3.8402519023514724`*^9, 3.840251967736549*^9}, {
   3.840252045698304*^9, 3.840252054495208*^9}, {3.8402525657991257`*^9, 
   3.840252572799258*^9}, {3.8402526549468775`*^9, 3.8402526562769156`*^9}, {
   3.8402527046258173`*^9, 3.840252707284704*^9}, {3.84025300112749*^9, 
   3.840253008090928*^9}, {3.840665189874135*^9, 3.840665198645383*^9}, {
   3.8406653163296595`*^9, 3.8406653189648247`*^9}, {3.8406665543483763`*^9, 
   3.840666557473755*^9}, {3.840666627973772*^9, 3.840666635584837*^9}, {
   3.840668067742684*^9, 3.840668075233445*^9}, {3.8406681255046096`*^9, 
   3.840668127921956*^9}, {3.840668233092184*^9, 3.8406682367392635`*^9}, {
   3.8406683117077503`*^9, 3.840668317504787*^9}, {3.8421788201707745`*^9, 
   3.8421788220775356`*^9}, {3.8421788627801423`*^9, 3.842178868436454*^9}, {
   3.8421788991592555`*^9, 3.842178950217716*^9}, {3.842180985749017*^9, 
   3.8421809963900037`*^9}, {3.8422321671868677`*^9, 3.84223216948344*^9}, {
   3.8422343013271227`*^9, 3.842234301889599*^9}, {3.842235477889629*^9, 
   3.842235480655204*^9}, {3.8422355636708145`*^9, 3.8422355660458374`*^9}, {
   3.8422364189524307`*^9, 3.8422364207337494`*^9}, {3.8423200857486076`*^9, 
   3.8423200882793036`*^9}, {3.8423267482477684`*^9, 3.842326758667205*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"da5e7ff2-71c0-4208-9ac6-64204413a215"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8248832307228994`*^9, 3.824883232679021*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"84724aa0-2d74-4ac7-92c4-79bec652678e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"nodos", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "L0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x\>\"", ",", "\"\<x\>\""}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"L0", ",", "L0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x\>\"", ",", "\"\<x\>\""}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "P"}], ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "L0"}], ",", "L0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<x\>\"", ",", "\"\<x\>\"", ",", "\"\<x\>\""}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"P", "/", "6"}], ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "L0"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "\"\<x\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
     "\[IndentingNewLine]", "}"}], "/.", "datos"}]}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"coordenadas", "/", "desplazamientos"}], " ", "y", " ", 
    RowBox[{"giros", "/", "fuerzas"}], " ", "y", " ", "momento"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"material", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"vE", ",", "fy"}], "}"}], "}"}], "/.", "datos"}]}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{"una", " ", "lista", " ", "por", " ", "material"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"perfil", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"A", ",", "Iy", ",", "Sy"}], "}"}], "}"}], "/.", "datos"}]}], 
  ";", 
  RowBox[{"(*", " ", 
   RowBox[{"una", " ", "lista", " ", "por", " ", "perfil"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"barras", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], "/.", 
    "datos"}]}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"nodos", "/", "material"}], " ", "y", " ", 
    RowBox[{"perfil", "/", "qx"}], " ", "y", " ", "qy", " ", 
    RowBox[{
     RowBox[{"(", "locales", ")"}], "/", "rigidez"}], " ", "rotacional", " ", 
    "secciones", " ", "extremas", " ", 
    RowBox[{"(", 
     RowBox[{"kN", "\[CenterDot]", 
      RowBox[{"m", "/", "rad"}]}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.824883050411138*^9, 3.824883224314022*^9}, {
   3.8248841446340065`*^9, 3.824884218249561*^9}, 3.8248854084137993`*^9, {
   3.8249020332238264`*^9, 3.824902037723857*^9}, {3.824967478612815*^9, 
   3.824967479878155*^9}, {3.8249676257688*^9, 3.8249676798628836`*^9}, {
   3.8249677142063613`*^9, 3.824967763784465*^9}, {3.82497358179986*^9, 
   3.8249736746125326`*^9}, {3.82497599200303*^9, 3.824975998362917*^9}, {
   3.8297593473831887`*^9, 3.8297593495863047`*^9}, {3.829759419164319*^9, 
   3.8297594205015364`*^9}, {3.8297866080706716`*^9, 
   3.8297866165861125`*^9}, {3.8297869128362923`*^9, 3.829786919914501*^9}, {
   3.829786977867752*^9, 3.829786978419875*^9}, {3.8396455376115313`*^9, 
   3.839645553469556*^9}, 3.839645615004803*^9, {3.8421789880775557`*^9, 
   3.842179088280272*^9}, {3.8421793378896403`*^9, 3.8421793515303807`*^9}, {
   3.8421799457643604`*^9, 3.8421799459678693`*^9}, {3.8421799814520063`*^9, 
   3.842179981655399*^9}, 3.8422323036082525`*^9, {3.842232590108226*^9, 
   3.842232590327158*^9}, {3.8422328986866655`*^9, 3.842232900998995*^9}, {
   3.8422349174365435`*^9, 3.8422349471397915`*^9}, 3.8422354477801228`*^9, {
   3.8422355124362507`*^9, 3.842235513264811*^9}, {3.8422421705937185`*^9, 
   3.8422421759684176`*^9}, 3.8422427198594947`*^9, {3.842243016437022*^9, 
   3.8422430166563473`*^9}, {3.84224312626513*^9, 3.8422431362969217`*^9}, 
   3.8422529918748446`*^9, {3.8422545907495203`*^9, 3.8422545921559334`*^9}, {
   3.8422699302029967`*^9, 3.842269930421609*^9}, {3.8422775062810955`*^9, 
   3.842277627155842*^9}, {3.842277658593405*^9, 3.842277683859335*^9}, {
   3.842580928773467*^9, 3.842580982464964*^9}, {3.842581014039149*^9, 
   3.842581034879345*^9}, {3.842591321423251*^9, 3.8425913324732113`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"212c7762-3035-4931-aabe-d35ddbf6cd4a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"nd", "=", 
    RowBox[{"Length", "[", "nodos", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"numero", " ", "de", " ", "nudos"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"Length", "[", "barras", "]"}]}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"numero", " ", "de", " ", "barras"}], " ", 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{3.824883274040423*^9},
 CellLabel->"In[9]:=",ExpressionUUID->"b4150091-49b7-4fdd-8322-b6797d79d5a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"matriz", " ", "de", " ", "rigidez", " ", "elemental", " ", 
    RowBox[{"(", "globales", ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"s", "=", "3"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"gdl", "/", "nudo"}], ",", " ", 
     RowBox[{"tipo", " ", "de", " ", "problema"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Fe", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "nb", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "s"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", "s"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xy", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"nodos", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "nd"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"b", "=", "1"}], ",", 
     RowBox[{"b", "<=", "nb"}], ",", 
     RowBox[{"b", "++"}], ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Elemento = \>\"", ",", "b"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"i", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"barras", "[", 
           RowBox[{"[", "b", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"j", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"barras", "[", 
           RowBox[{"[", "b", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"L", "=", 
        RowBox[{"\[Sqrt]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"xy", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"xy", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"xy", "[", 
                RowBox[{"[", "j", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], "-", 
              RowBox[{
               RowBox[{"xy", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], 
          ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        SubscriptBox["\[Lambda]", "X"], "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"xy", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"xy", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "L"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(X\)\(\\\ \)\)]\)= \>\"", 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{
           SubscriptBox["\[Lambda]", "X"], ",", "3"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        SubscriptBox["\[Lambda]", "Y"], "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"xy", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", 
           RowBox[{
            RowBox[{"xy", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "/", "L"}]}], ";", "\n", 
       "\t", 
       RowBox[{"Print", "[", 
        RowBox[{
        "\"\<\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(Y\)\(\\\ \)\)]\)= \>\"", 
         ",", 
         RowBox[{"N", "[", 
          RowBox[{
           SubscriptBox["\[Lambda]", "Y"], ",", "3"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"kk", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Nx", "[", "b", "]"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Mz", "[", 
              RowBox[{"b", ",", "j"}], "]"}], "+", 
             RowBox[{"Mz", "[", 
              RowBox[{"b", ",", "i"}], "]"}]}], ")"}], "/", "L"}], ",", 
          RowBox[{"Mz", "[", 
           RowBox[{"b", ",", "i"}], "]"}], ",", 
          RowBox[{"Nx", "[", "b", "]"}], ",", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Mz", "[", 
               RowBox[{"b", ",", "j"}], "]"}], "+", 
              RowBox[{"Mz", "[", 
               RowBox[{"b", ",", "i"}], "]"}]}], ")"}]}], "/", "L"}], ",", 
          RowBox[{"Mz", "[", 
           RowBox[{"b", ",", "j"}], "]"}]}], "}"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Part", "[", 
         RowBox[{"Fe", ",", "b"}], "]"}], "=", " ", 
        RowBox[{
         RowBox[{"Transpose", "[", 
          RowBox[{"T", "[", 
           RowBox[{
            SubscriptBox["\[Lambda]", "X"], ",", 
            SubscriptBox["\[Lambda]", "Y"]}], "]"}], "]"}], ".", "kk"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"MatrixForm", "[", 
         RowBox[{"Fe", "[", 
          RowBox[{"[", "b", "]"}], "]"}], "]"}], "]"}], ";"}], "\n", "\t", 
      "}"}]}], "\n", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.824883359704213*^9, 3.824883365920402*^9}, 
   3.8248834218100634`*^9, {3.824883486299941*^9, 3.8248836980299273`*^9}, {
   3.8249677805191298`*^9, 3.824967940347165*^9}, {3.8249711471907735`*^9, 
   3.824971150987585*^9}, {3.824975622362924*^9, 3.8249756333000665`*^9}, {
   3.824990226831185*^9, 3.8249902307687674`*^9}, {3.8421791280146065`*^9, 
   3.8421791281553645`*^9}, {3.8422453745781856`*^9, 3.842245396406378*^9}, {
   3.842245475390506*^9, 3.8422455842344775`*^9}, 3.842245857968424*^9, {
   3.842246138171509*^9, 3.842246161359044*^9}, {3.8422519542653146`*^9, 
   3.842251971187673*^9}, {3.842367191236574*^9, 3.8423671997665896`*^9}, {
   3.8424068280884857`*^9, 3.8424068334934635`*^9}, {3.842410526236106*^9, 
   3.8424105326408577`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"28270041-c78d-4380-a5b4-952ada8ec8da"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Elemento = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["Elemento = ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.842591609736022*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"5677a5f3-a333-4137-94be-3134065dba1e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(X\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(X\)\(\\ \)\)]\)= ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.842591609736022*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"1ab6d244-4620-48ee-b1f1-7af245411a22"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(Y\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(Y\)\(\\ \)\)]\)= ", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097431364`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"6456d929-be39-4a48-a91d-845fd8701ca1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "1"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "1"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"1", ",", "1"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "2"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097431364`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"f88c17ee-2ca6-4862-9bfe-c43c57415e53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Elemento = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["Elemento = ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097531424`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"3de471da-28cf-499f-ad13-8043b7bb400c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(X\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(X\)\(\\ \)\)]\)= ", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097531424`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"322b2182-9e35-402e-9fd8-8382b0c25c6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(Y\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(Y\)\(\\ \)\)]\)= ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.842591609758168*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"c93717fe-6469-472c-a413-ea58efe13703"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "2"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "2"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "3"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.842591609758168*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"3e024298-8eb5-4272-a481-dab705b3b24a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Elemento = \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Elemento = ", 3],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097632055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"3ac4f250-b9f6-47d5-a2dc-9b1716691ed2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(X\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(X\)\(\\ \)\)]\)= ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097632055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"5631328c-70fb-415a-94da-81f8c4fd5094"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(Y\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(Y\)\(\\ \)\)]\)= ", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097632055`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"a87dc13c-e497-482e-9a3f-7d7f34a8eb97"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "4"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "5"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "4"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "4"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097733836`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"9462cf02-87cc-4e88-85aa-7a83c61df5ca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Elemento = \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm["Elemento = ", 4],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097733836`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"ba32c789-48f4-4ba4-a9d7-a771a68c5a92"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(X\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.`"}]}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(X\)\(\\ \)\)]\)= ", -1.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097733836`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"98207a04-186b-4a74-8969-1ebf49249761"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\t\\!\\(\\*SubscriptBox[\\(\[Lambda]\\), \\(\\(Y\\)\\(\\\\ \
\\)\\)]\\)= \"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm[
  "\t\!\(\*SubscriptBox[\(\[Lambda]\), \(\(Y\)\(\\ \)\)]\)= ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097733836`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"681b6947-9f53-43e4-82b6-26a267b677cb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "3"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "4"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "3"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "3"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.8248834408299236`*^9, {3.8248834968801937`*^9, 3.8248835604300995`*^9}, 
   3.8248836628099833`*^9, 3.824883698150222*^9, 3.8248839677698383`*^9, 
   3.8248848540339355`*^9, 3.824885913758553*^9, 3.8248859978982124`*^9, 
   3.824886066688113*^9, 3.8248861331829395`*^9, 3.8248862543267946`*^9, 
   3.8248863036379967`*^9, {3.8248863432487965`*^9, 3.8248863702379303`*^9}, 
   3.8248864064085526`*^9, 3.8248864621407394`*^9, 3.8248865123580723`*^9, 
   3.8249006216617355`*^9, 3.824902055005224*^9, 3.8249045826927724`*^9, 
   3.8249615476835833`*^9, {3.824967828753497*^9, 3.8249678496441145`*^9}, 
   3.8249678968783937`*^9, 3.8249679431909904`*^9, 3.8249688727531824`*^9, 
   3.824969063065817*^9, 3.8249699870971594`*^9, {3.8249706194096923`*^9, 
   3.824970644269017*^9}, 3.824971111128087*^9, 3.824971164237485*^9, 
   3.8249715815968585`*^9, 3.824971725628149*^9, 3.8249728846281147`*^9, 
   3.8249729772533116`*^9, 3.8249730936280904`*^9, 3.824973461909569*^9, 
   3.8249755994093437`*^9, 3.824975633846981*^9, 3.824976017815941*^9, 
   3.824977042518751*^9, 3.8249770794405823`*^9, 3.824977827425061*^9, 
   3.824977888409813*^9, {3.824978005049984*^9, 3.824978032878132*^9}, 
   3.824978089159669*^9, 3.8249866419562535`*^9, 3.824986694487703*^9, 
   3.824986931206622*^9, 3.8249879175188093`*^9, 3.8249885628000526`*^9, 
   3.8249900712220354`*^9, 3.8249901548624725`*^9, 3.824990237659337*^9, 
   3.824990287675045*^9, 3.82499046695665*^9, {3.824990517940981*^9, 
   3.8249905477376766`*^9}, 3.824990579737487*^9, 3.824990749721919*^9, 
   3.824990790581193*^9, 3.824991125112702*^9, 3.8249911616127653`*^9, 
   3.824991210268718*^9, 3.82499173431563*^9, 3.8249917740656223`*^9, 
   3.8297433971176147`*^9, 3.8297436452773433`*^9, 3.8297437121332235`*^9, 
   3.8297437755864477`*^9, 3.8297438370551677`*^9, 3.8297439373052087`*^9, 
   3.8297440015393753`*^9, 3.829744063992446*^9, 3.82974417322243*^9, 
   3.8297496858360806`*^9, 3.8297518108893843`*^9, 3.8297519787891955`*^9, 
   3.8297522836958046`*^9, 3.8297573650861683`*^9, {3.8297574111378336`*^9, 
   3.829757434401218*^9}, 3.8297574713263903`*^9, 3.8297575657896743`*^9, 
   3.829757654330593*^9, {3.8297580548840733`*^9, 3.8297580697893457`*^9}, 
   3.8297585132735796`*^9, 3.829759121679804*^9, 3.829759361539727*^9, 
   3.829759432273963*^9, 3.8297597511173797`*^9, 3.829759822047902*^9, 
   3.8297598804926257`*^9, 3.8297656073675723`*^9, 3.829785770133292*^9, 
   3.8297864480548477`*^9, 3.8297865062427845`*^9, 3.829786563273848*^9, 
   3.829786620508106*^9, 3.829786761515236*^9, 3.8297869257427588`*^9, 
   3.8297869842169886`*^9, 3.8297952996175947`*^9, 3.829795554836516*^9, 
   3.8297969664457183`*^9, 3.8298632048708687`*^9, 3.8298633290423436`*^9, 
   3.829863391807886*^9, 3.8298634594488325`*^9, 3.829863845026918*^9, 
   3.8298646040267797`*^9, 3.829981044091563*^9, 3.8299814124980483`*^9, 
   3.8299822044824233`*^9, 3.8299823745134645`*^9, 3.829982554763719*^9, {
   3.830054972310237*^9, 3.8300549849043937`*^9}, 3.830055126716525*^9, 
   3.8300552279044333`*^9, 3.830055561185495*^9, 3.830055619413184*^9, 
   3.8300556683573103`*^9, 3.8300584574039545`*^9, 3.8310050213763514`*^9, 
   3.831005090566656*^9, 3.831005216626501*^9, 3.8310053271363993`*^9, 
   3.831005490613068*^9, 3.831019134224202*^9, 3.838882903708166*^9, 
   3.838882991404628*^9, 3.8388830725050087`*^9, 3.838883145489619*^9, 
   3.8388833385363607`*^9, 3.8388834422098207`*^9, 3.838883934864435*^9, 
   3.838883966596035*^9, 3.838884132833394*^9, 3.838884427676955*^9, 
   3.8388844801782*^9, 3.838884627886984*^9, 3.8388853147238564`*^9, {
   3.8388853596928945`*^9, 3.838885410724205*^9}, {3.8388854562109222`*^9, 
   3.8388854858176193`*^9}, {3.8388855236614885`*^9, 3.8388855465832243`*^9}, 
   3.8388855852393947`*^9, 3.839597149547944*^9, 3.839597365619034*^9, 
   3.839597577216653*^9, 3.83959770942047*^9, 3.839597754727908*^9, 
   3.839597820200602*^9, 3.839597902132306*^9, 3.839598134892112*^9, 
   3.8395981674916525`*^9, 3.839598321665452*^9, 3.8395983712054715`*^9, {
   3.8395984041486597`*^9, 3.839598430174775*^9}, 3.839598536959546*^9, 
   3.839598620757464*^9, 3.839598944378053*^9, {3.8395991748503704`*^9, 
   3.8395992019140477`*^9}, 3.83959930764623*^9, 3.839599403113293*^9, 
   3.839599489866313*^9, {3.839599849361326*^9, 3.839599866727808*^9}, {
   3.839599919327423*^9, 3.8395999696449146`*^9}, 3.83960001601114*^9, 
   3.839601130424429*^9, 3.8396011633390465`*^9, 3.8396012195684347`*^9, {
   3.8396013395338435`*^9, 3.839601361165826*^9}, 3.8396015054799275`*^9, 
   3.8396015656422987`*^9, {3.8396016091374006`*^9, 3.8396016329892435`*^9}, {
   3.83960169450309*^9, 3.839601716886654*^9}, 3.8396017924834595`*^9, {
   3.8396018500792255`*^9, 3.8396019785934715`*^9}, {3.8396025684128923`*^9, 
   3.83960258184898*^9}, 3.8396026466722536`*^9, {3.839638427853612*^9, 
   3.8396384408194504`*^9}, {3.8396384770799103`*^9, 3.839638491989386*^9}, {
   3.839639098677122*^9, 3.8396391574473424`*^9}, 3.8396392101408777`*^9, 
   3.8396392595286407`*^9, {3.8396393531229296`*^9, 3.8396394058644605`*^9}, {
   3.8396396992042265`*^9, 3.839639723543021*^9}, 3.839639834139391*^9, {
   3.839639873837779*^9, 3.8396399014380646`*^9}, 3.839645246248129*^9, 
   3.839645323766507*^9, 3.8396453597262325`*^9, {3.8396454010261755`*^9, 
   3.8396454264764504`*^9}, 3.8396455806475687`*^9, {3.839645619834751*^9, 
   3.839645635130024*^9}, {3.8396456703062096`*^9, 3.8396456894762707`*^9}, {
   3.8396475151855717`*^9, 3.839647531663839*^9}, 3.839687549806959*^9, 
   3.8397282586948333`*^9, 3.8397292108594465`*^9, 3.839729669554411*^9, 
   3.839729717115383*^9, 3.8397297537321725`*^9, {3.839859640926853*^9, 
   3.8398596626230865`*^9}, {3.839859837196314*^9, 3.839859885522294*^9}, 
   3.8399427230989323`*^9, {3.8399427600206723`*^9, 3.8399427768648734`*^9}, 
   3.839942813386531*^9, {3.839943018286479*^9, 3.83994310314567*^9}, 
   3.83994314211438*^9, {3.8399432006613965`*^9, 3.839943275458192*^9}, 
   3.8400287425541797`*^9, 3.840250970096058*^9, 3.840251838518019*^9, 
   3.8402519077413254`*^9, {3.840251939689732*^9, 3.840251969080388*^9}, 
   3.84025205601794*^9, 3.840252576815171*^9, 3.8402526578376913`*^9, 
   3.8402527089399257`*^9, 3.840252740142812*^9, 3.8402530095783253`*^9, 
   3.8406651514266987`*^9, 3.840665199738925*^9, 3.840665292969966*^9, 
   3.8406653299889803`*^9, 3.8406665666534147`*^9, 3.8406666452858667`*^9, 
   3.8406680834892244`*^9, 3.840668136975405*^9, 3.8406682821927166`*^9, 
   3.840668326661072*^9, {3.8421791012959347`*^9, 3.8421791303741875`*^9}, 
   3.8421793636240535`*^9, 3.8421805605927076`*^9, {3.8421811973896217`*^9, 
   3.8421812366239347`*^9}, 3.8421813311712503`*^9, 3.8422301382177367`*^9, 
   3.842231144295947*^9, 3.842232182171*^9, 3.842232322452098*^9, 
   3.8422326212492046`*^9, 3.84223293212411*^9, {3.842232999624002*^9, 
   3.842233024342787*^9}, 3.842233073952124*^9, 3.8422331108740435`*^9, {
   3.842234046280197*^9, 3.842234076483498*^9}, 3.8422341263272285`*^9, {
   3.8422343034522*^9, 3.8422343199209595`*^9}, {3.842234365170892*^9, 
   3.842234402436597*^9}, {3.8422344510146112`*^9, 3.842234475780279*^9}, 
   3.8422345123584385`*^9, {3.842234661452135*^9, 3.8422347221239996`*^9}, {
   3.842234768077257*^9, 3.8422347831396284`*^9}, {3.8422349183271875`*^9, 
   3.84223493121809*^9}, 3.842235300358573*^9, 3.8422354486397386`*^9, 
   3.842235482061559*^9, {3.842235515905286*^9, 3.8422355312490435`*^9}, 
   3.842235567077092*^9, 3.8422356103271093`*^9, 3.8422364232646317`*^9, 
   3.842242202249876*^9, 3.842242720781003*^9, 3.842242815296546*^9, {
   3.8422430201248603`*^9, 3.842243040093715*^9}, 3.842243137968655*^9, {
   3.842245575968586*^9, 3.842245584562652*^9}, 3.8422458582341824`*^9, {
   3.84224616174971*^9, 3.8422461743434505`*^9}, 3.8422477727496614`*^9, {
   3.842248058015439*^9, 3.842248080171709*^9}, 3.842248797187431*^9, 
   3.842251313468542*^9, 3.8422519764528685`*^9, 3.842252995624961*^9, {
   3.8422545941875935`*^9, 3.842254609030929*^9}, 3.8422546617028217`*^9, 
   3.8422668135779696`*^9, 3.842266986874752*^9, {3.8422670429529524`*^9, 
   3.8422670589372053`*^9}, 3.8422699319376554`*^9, 3.84227061049977*^9, 
   3.8422709362340975`*^9, 3.842270977031252*^9, {3.842271225968416*^9, 
   3.842271249421553*^9}, 3.842277697437585*^9, 3.8423196611254673`*^9, 
   3.842319715326383*^9, 3.84232385182478*^9, 3.842360987313486*^9, 
   3.842361447891816*^9, {3.8423624242510276`*^9, 3.842362442969923*^9}, 
   3.842367207516592*^9, 3.842367334501264*^9, 3.8423682086419897`*^9, 
   3.842406834496934*^9, 3.8424071011099577`*^9, 3.84241053611892*^9, {
   3.842410592311194*^9, 3.8424106138541803`*^9}, 3.842410770505069*^9, 
   3.842411268301591*^9, 3.8424117084207993`*^9, {3.842424238728091*^9, 
   3.842424247493947*^9}, {3.8424244905092983`*^9, 3.842424512571801*^9}, 
   3.842444433306301*^9, 3.8424448452125053`*^9, 3.842444880665615*^9, 
   3.84244491638437*^9, 3.8424450747907686`*^9, 3.8424451656813073`*^9, {
   3.842445204181181*^9, 3.8424452219936714`*^9}, 3.842445253931168*^9, 
   3.842445352087449*^9, 3.8424454048217945`*^9, 3.8424454639937267`*^9, 
   3.842445775603382*^9, 3.8424467448845496`*^9, 3.8424473286500883`*^9, 
   3.8424476496969037`*^9, 3.8424479297124853`*^9, 3.8424479742593093`*^9, 
   3.8424481837593527`*^9, 3.8424482890093746`*^9, {3.842448382149952*^9, 
   3.842448400947116*^9}, {3.842448678181571*^9, 3.842448695353222*^9}, 
   3.8424489439625006`*^9, 3.8424490954311633`*^9, 3.842449230446819*^9, {
   3.842449315743656*^9, 3.842449332947106*^9}, 3.8424494239312086`*^9, 
   3.84244950894685*^9, 3.8425722390934563`*^9, {3.842572319593631*^9, 
   3.8425723483278985`*^9}, 3.842572507609144*^9, 3.842572620406083*^9, {
   3.8425727253590937`*^9, 3.84257275106227*^9}, {3.8425729910626907`*^9, 
   3.84257301810909*^9}, {3.8425784539802713`*^9, 3.842578472664647*^9}, 
   3.8425787499461384`*^9, 3.842578800165636*^9, 3.842579047575019*^9, 
   3.842581047220169*^9, {3.8425823296164083`*^9, 3.8425823508764973`*^9}, 
   3.8425824908685555`*^9, 3.8425825361770535`*^9, 3.8425832916077037`*^9, 
   3.8425833793487945`*^9, 3.8425834760861344`*^9, {3.8425835366172113`*^9, 
   3.842583554529131*^9}, {3.8425837632111206`*^9, 3.842583772769026*^9}, {
   3.8425838112513833`*^9, 3.842583837119347*^9}, 3.8425838796136904`*^9, {
   3.8425840581932974`*^9, 3.8425840723889656`*^9}, 3.842584261782568*^9, {
   3.8425843558853583`*^9, 3.8425843759847784`*^9}, 3.84258459797231*^9, 
   3.8425847119781904`*^9, 3.8425849145864015`*^9, 3.8425849520052257`*^9, 
   3.842585086348894*^9, {3.842585182249007*^9, 3.842585196665985*^9}, 
   3.842591336137867*^9, 3.842591465363347*^9, 3.8425916097833214`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[11]:=",ExpressionUUID->"409e06f0-038b-4054-ab46-2f4060050733"]
}, Open  ]]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.824884412839452*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"998ab602-f887-4c22-b0eb-461a661d4878"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"ensamblar", " ", "fuerzas", " ", "equivalentes"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"s", "=", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ngdl", "=", 
     RowBox[{"s", " ", "nd"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Feqv", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0.0", ",", 
       RowBox[{"{", "ngdl", "}"}]}], "]"}]}], ";"}], "\n", "\n", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"b", "=", "1"}], ",", 
      RowBox[{"b", "<=", "nb"}], ",", 
      RowBox[{"b", "++"}], ",", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"i", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"barras", "[", 
            RowBox[{"[", "b", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"j", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"barras", "[", 
            RowBox[{"[", "b", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"nudo", " ", "i"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"f", "=", "1"}], ",", 
          RowBox[{"f", "<=", "s"}], ",", 
          RowBox[{"f", "++"}], ",", 
          RowBox[{"(*", "filas", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Part", "[", 
             RowBox[{"Feqv", ",", 
              RowBox[{
               RowBox[{"s", 
                RowBox[{"(", 
                 RowBox[{"i", "-", "1"}], ")"}]}], "+", "f"}]}], "]"}], "+=", 
            RowBox[{"Part", "[", 
             RowBox[{"Fe", ",", "b", ",", "f"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"nudo", " ", "j"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"f", "=", "1"}], ",", 
          RowBox[{"f", "<=", "s"}], ",", 
          RowBox[{"f", "++"}], ",", 
          RowBox[{"(*", "filas", "*)"}], "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"Part", "[", 
             RowBox[{"Feqv", ",", 
              RowBox[{
               RowBox[{"s", 
                RowBox[{"(", 
                 RowBox[{"j", "-", "1"}], ")"}]}], "+", "f"}]}], "]"}], "+=", 
            RowBox[{"Part", "[", 
             RowBox[{"Fe", ",", "b", ",", 
              RowBox[{"s", "+", "f"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", "}"}]}], 
     "\n", "]"}], ";"}], "\n", 
   RowBox[{"MatrixForm", "[", 
    RowBox[{"Feqv", ",", "7"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.8248849657389603`*^9, 3.8248851298439417`*^9}, {
  3.84224577081225*^9, 3.842245800577853*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"5ed8cdf5-8891-4bed-940d-9fc322a00d72"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "1"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "1"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"1", ",", "1"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "2"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}], "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "2"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "3"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "3"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "3"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "4"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "3"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "4"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "4"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "4"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "5"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, 7]]]], "Output",
 CellChangeTimes->{
  3.748144727080939*^9, {3.801121686351407*^9, 3.801121700642407*^9}, {
   3.801121825584408*^9, 3.801121851074808*^9}, 3.8011218891866083`*^9, 
   3.8011220312402086`*^9, {3.8011220678534093`*^9, 3.801122078180609*^9}, 
   3.801140555138415*^9, 3.8011415747630186`*^9, 3.801141605510619*^9, 
   3.8011419834694214`*^9, 3.8011420338418217`*^9, 3.8011420812814217`*^9, 
   3.8011424279330244`*^9, 3.8011433784616303`*^9, 3.8011439938076344`*^9, 
   3.8011450777750397`*^9, {3.801146056993643*^9, 3.801146107788243*^9}, 
   3.8012059896549587`*^9, 3.815027415653819*^9, {3.8248851305392056`*^9, 
   3.8248851426888795`*^9}, 3.8248859140884466`*^9, 3.824885998248155*^9, 
   3.824886067044672*^9, 3.824886133548252*^9, 3.8248862547003026`*^9, 
   3.824886304031616*^9, {3.8248863436179667`*^9, 3.824886370552657*^9}, 
   3.824886406726345*^9, 3.8248864624616084`*^9, 3.824886512723078*^9, 
   3.8249006220054502`*^9, 3.824902055333541*^9, 3.8249045829895983`*^9, 
   3.8249615480936146`*^9, 3.824968016800456*^9, {3.8249680662999725`*^9, 
   3.8249680889252357`*^9}, 3.8249688730347033`*^9, 3.8249690633624926`*^9, 
   3.8249699873782225`*^9, {3.824970619706648*^9, 3.824970644565668*^9}, 
   3.824971111487539*^9, 3.824971300784565*^9, 3.82497158187813*^9, 
   3.8249717259250193`*^9, 3.824972909706245*^9, 3.8249729775499988`*^9, 
   3.8249730938939238`*^9, 3.824973462206681*^9, 3.8249756891751485`*^9, 
   3.824976018190624*^9, 3.8249770429095254`*^9, 3.8249770797999926`*^9, 
   3.8249778278158927`*^9, 3.8249778888000293`*^9, {3.8249780053473372`*^9, 
   3.8249780332533836`*^9}, 3.8249780895188723`*^9, 3.8249866422848434`*^9, 
   3.8249866948627634`*^9, 3.8249869315813584`*^9, 3.82498791786248*^9, 
   3.824988563253251*^9, 3.8249900715502844`*^9, 3.824990155190628*^9, 
   3.8249903163157196`*^9, 3.8249904672378097`*^9, {3.824990518206213*^9, 
   3.8249905480189495`*^9}, 3.824990580003421*^9, 3.8249907500033164`*^9, 
   3.824990790846972*^9, 3.8249911254253407`*^9, 3.8249911618940353`*^9, 
   3.8249912105343237`*^9, 3.824991734565772*^9, 3.824991774331322*^9, 
   3.829743397425929*^9, 3.829743645539628*^9, 3.8297437124142733`*^9, 
   3.829743775867592*^9, 3.8297438373516855`*^9, 3.829743937574*^9, 
   3.82974400177985*^9, 3.8297440642893076`*^9, 3.829744173508009*^9, 
   3.82974968614894*^9, 3.829751813258251*^9, 3.8297519810023513`*^9, 
   3.82975228386742*^9, 3.8297573653675613`*^9, {3.829757411354082*^9, 
   3.829757434701743*^9}, 3.829757471602129*^9, 3.8297575660548253`*^9, 
   3.8297576545392256`*^9, {3.829758055164276*^9, 3.8297580700552654`*^9}, 
   3.829758513555098*^9, 3.829759121945899*^9, 3.8297593618208504`*^9, 
   3.829759432536203*^9, 3.829759751445613*^9, 3.8297598223360767`*^9, 
   3.8297598808206635`*^9, 3.8297656096333914`*^9, 3.8297857723517694`*^9, 
   3.8297864502423935`*^9, 3.8297865084769816`*^9, 3.829786565507963*^9, 
   3.829786621836278*^9, 3.829786763711288*^9, 3.8297869260080137`*^9, 
   3.829786984492404*^9, 3.829795299904755*^9, 3.8297955550548286`*^9, 
   3.8297969667111173`*^9, 3.8298632051520205`*^9, 3.8298633293392577`*^9, 
   3.8298633921048126`*^9, 3.8298634597068644`*^9, 3.829863845285432*^9, 
   3.8298646042766438`*^9, 3.8299810443883963`*^9, 3.829981412716529*^9, 
   3.829982204732332*^9, 3.829982374779312*^9, 3.829982555013476*^9, {
   3.8300549725290947`*^9, 3.8300549862790384`*^9}, 3.830055126904044*^9, 
   3.8300552302635345`*^9, 3.830055563394861*^9, 3.830055620783193*^9, 
   3.8300556705067053`*^9, 3.8300584595983086`*^9, 3.831005021696537*^9, 
   3.8310050919267626`*^9, 3.8310052180165787`*^9, 3.8310053293966217`*^9, 
   3.8310054909168463`*^9, 3.831019134425033*^9, 3.8388829039273186`*^9, 
   3.8388829926617165`*^9, 3.8388830728175907`*^9, 3.8388831458022366`*^9, 
   3.838883366067544*^9, 3.838883442723772*^9, 3.8388839351144934`*^9, 
   3.8388839667863755`*^9, 3.8388841331145515`*^9, 3.838884427989444*^9, 
   3.8388844804897933`*^9, 3.8388846280718145`*^9, 3.8388853149741335`*^9, {
   3.8388853598958497`*^9, 3.8388854109396563`*^9}, {3.8388854564075813`*^9, 
   3.838885486005088*^9}, {3.838885523848997*^9, 3.8388855467706614`*^9}, 
   3.838885585426917*^9, 3.8395971667378397`*^9, 3.839597594282794*^9, 
   3.8395977096131077`*^9, 3.8395977549613094`*^9, 3.8395978203905215`*^9, 
   3.8395979024049263`*^9, 3.839598135157731*^9, 3.8395981677557497`*^9, 
   3.8395983219555845`*^9, 3.8395983714920125`*^9, {3.8395984044576774`*^9, 
   3.839598430392721*^9}, 3.839598537241897*^9, 3.839598620994776*^9, 
   3.839598944527035*^9, {3.839599175068874*^9, 3.839599202153801*^9}, 
   3.8395993078795004`*^9, 3.8395994033817644`*^9, 3.8395994901454287`*^9, {
   3.8395998495725155`*^9, 3.8395998669375453`*^9}, {3.8395999194865484`*^9, 
   3.8395999699022264`*^9}, 3.839600016324809*^9, 3.8396011305933433`*^9, 
   3.8396011636392627`*^9, 3.8396012197296877`*^9, {3.8396013398280573`*^9, 
   3.839601361316416*^9}, 3.8396015056946726`*^9, 3.839601565874264*^9, {
   3.839601609373842*^9, 3.8396016332989197`*^9}, {3.8396016946542935`*^9, 
   3.8396017171246967`*^9}, 3.8396017927352867`*^9, {3.839601850333195*^9, 
   3.839601978827053*^9}, {3.8396025686638985`*^9, 3.8396025841450977`*^9}, 
   3.839602646878107*^9, {3.8396384280606785`*^9, 3.839638441007802*^9}, {
   3.8396384772609625`*^9, 3.839638492174326*^9}, {3.8396390988900857`*^9, 
   3.8396391576566343`*^9}, 3.8396392103620863`*^9, 3.8396392597590246`*^9, {
   3.8396393533552012`*^9, 3.839639406981632*^9}, {3.83963969940571*^9, 
   3.839639723758678*^9}, 3.839639834389183*^9, {3.839639873985613*^9, 
   3.8396399016741533`*^9}, 3.8396452464799743`*^9, 3.8396453240195646`*^9, 
   3.839645360035411*^9, {3.8396454011820793`*^9, 3.8396454266969995`*^9}, 
   3.8396455808654976`*^9, {3.839645620079757*^9, 3.839645635365486*^9}, {
   3.839645670551609*^9, 3.839645689700159*^9}, {3.839647515427266*^9, 
   3.8396475319130464`*^9}, 3.839687550117156*^9, 3.8397282590459414`*^9, 
   3.839729210999239*^9, 3.8397296698129034`*^9, 3.8397297173141713`*^9, 
   3.8397297539259815`*^9, {3.8398596412100954`*^9, 3.8398596629151716`*^9}, {
   3.8398598374449177`*^9, 3.8398598858255415`*^9}, 3.8399427234352064`*^9, {
   3.839942760208448*^9, 3.839942777052245*^9}, 3.839942813567952*^9, {
   3.8399430185362964`*^9, 3.839943103349024*^9}, 3.8399431443804135`*^9, {
   3.839943200851259*^9, 3.839943277661686*^9}, 3.8400287427947826`*^9, 
   3.8402509703202114`*^9, 3.8402518388461633`*^9, 3.84025190789314*^9, {
   3.8402519398927627`*^9, 3.840251969299429*^9}, 3.8402520562367945`*^9, 
   3.8402525770335813`*^9, 3.8402526580380945`*^9, 3.8402527090802927`*^9, 
   3.8402527403930955`*^9, 3.8402530097211323`*^9, 3.840665151645564*^9, 
   3.84066519994232*^9, 3.840665293161178*^9, 3.8406653301764917`*^9, 
   3.8406665668797274`*^9, 3.8406666455045843`*^9, 3.8406680836922197`*^9, 
   3.8406681371766787`*^9, 3.840668282377224*^9, 3.8406683268643227`*^9, 
   3.842179188717681*^9, 3.842179363858565*^9, 3.842180562030222*^9, {
   3.8421811976241107`*^9, 3.8421812388740144`*^9}, 3.8421813313897505`*^9, 
   3.8422301407177444`*^9, 3.8422311446083403`*^9, 3.84223218246809*^9, 
   3.842232322733512*^9, 3.842232621577103*^9, 3.8422329324210835`*^9, {
   3.8422329999208765`*^9, 3.8422330246399965`*^9}, 3.842233074248993*^9, 
   3.842233111186834*^9, {3.8422340465775185`*^9, 3.8422340767961893`*^9}, 
   3.842234126717916*^9, {3.8422343037646666`*^9, 3.8422343202959003`*^9}, {
   3.842234365483368*^9, 3.8422344027491302`*^9}, {3.8422344513272085`*^9, 
   3.842234476077306*^9}, 3.8422345126709504`*^9, {3.84223466174903*^9, 
   3.842234722436826*^9}, {3.8422347684208317`*^9, 3.842234783467843*^9}, {
   3.8422349186710634`*^9, 3.8422349315617094`*^9}, 3.842235300623963*^9, 
   3.842235448983611*^9, 3.8422354824055147`*^9, {3.8422355162489324`*^9, 
   3.8422355317022343`*^9}, 3.8422355674365234`*^9, 3.8422356107021704`*^9, 
   3.8422364236243463`*^9, 3.8422422026559105`*^9, 3.842242721156205*^9, 
   3.842242815687198*^9, {3.8422430204686055`*^9, 3.8422430404528837`*^9}, 
   3.8422431383277893`*^9, 3.8422457455626187`*^9, {3.8422457952185526`*^9, 
   3.8422458012029524`*^9}, 3.8422458610778484`*^9, 3.8422461745465565`*^9, 
   3.84224777296848*^9, {3.8422480581248426`*^9, 3.8422480802811337`*^9}, 
   3.842248797281105*^9, 3.842251313593564*^9, 3.8422520028903165`*^9, 
   3.8422529957341633`*^9, {3.842254594281327*^9, 3.8422546091407385`*^9}, 
   3.8422546618126516`*^9, 3.8422668136873446`*^9, 3.8422669869685526`*^9, {
   3.8422670430468335`*^9, 3.842267059031012*^9}, 3.842269812203226*^9, 
   3.8422699320312395`*^9, 3.842270610609106*^9, 3.8422709363590665`*^9, 
   3.842270977155978*^9, {3.842271226109396*^9, 3.8422712495468025`*^9}, 
   3.8422777039997244`*^9, 3.8423196612348413`*^9, 3.842319715428602*^9, 
   3.842323851995799*^9, 3.8423609874229393`*^9, 3.8423614480013757`*^9, {
   3.842362424360507*^9, 3.842362443094808*^9}, 3.8423672077041483`*^9, 
   3.8423673346573286`*^9, 3.8423682088291316`*^9, 3.8424068346264577`*^9, 
   3.842407101250551*^9, 3.842410536290744*^9, {3.8424105924830284`*^9, 
   3.842410614088502*^9}, 3.842410770676901*^9, 3.8424112684890385`*^9, 
   3.842411708596196*^9, {3.8424242388531933`*^9, 3.842424247634653*^9}, {
   3.8424244906655903`*^9, 3.8424245127124596`*^9}, 3.842444433415637*^9, 
   3.842444845337475*^9, 3.8424448807906523`*^9, 3.842444916509331*^9, 
   3.842445074931238*^9, 3.8424451658062525`*^9, {3.8424452043065214`*^9, 
   3.84244522211872*^9}, 3.8424452540566425`*^9, 3.8424453522128696`*^9, 
   3.8424454049471965`*^9, 3.842445464118665*^9, 3.842445775728368*^9, 
   3.8424467450093575`*^9, 3.8424473287909193`*^9, 3.842447649837781*^9, 
   3.8424479298690166`*^9, 3.842447974415522*^9, 3.8424481839003553`*^9, 
   3.8424482891656733`*^9, {3.842448382321822*^9, 3.842448401103438*^9}, {
   3.8424486783223658`*^9, 3.842448695509475*^9}, 3.8424489441191406`*^9, 
   3.8424490956032314`*^9, 3.8424492305879264`*^9, {3.842449315946811*^9, 
   3.8424493331658335`*^9}, 3.84244942408747*^9, 3.8424495090878057`*^9, 
   3.84257223923437*^9, {3.842572319718769*^9, 3.842572348437523*^9}, 
   3.842572507734366*^9, 3.8425726205311403`*^9, {3.8425727254841166`*^9, 
   3.8425727511719923`*^9}, {3.842572991203049*^9, 3.8425730182499604`*^9}, {
   3.842578454105242*^9, 3.842578472773992*^9}, 3.842578750076828*^9, 
   3.842578800306259*^9, 3.842579047692211*^9, 3.8425810473139253`*^9, {
   3.8425823297257614`*^9, 3.842582350970224*^9}, 3.84258249097968*^9, 
   3.842582536270626*^9, 3.8425832917349634`*^9, 3.842583379473795*^9, 
   3.842583476195486*^9, {3.842583536726591*^9, 3.84258355463848*^9}, {
   3.8425837633204975`*^9, 3.8425837728965445`*^9}, {3.8425838113515053`*^9, 
   3.842583837237012*^9}, 3.8425838797246785`*^9, {3.84258405830267*^9, 
   3.8425840724983225`*^9}, 3.842584261899809*^9, {3.8425843559946756`*^9, 
   3.8425843760941277`*^9}, 3.8425845980972767`*^9, 3.842584712087572*^9, 
   3.8425849146946096`*^9, 3.842584952115588*^9, 3.8425850864753275`*^9, {
   3.842585182373982*^9, 3.842585196790991*^9}, 3.8425913362281876`*^9, 
   3.842591465447012*^9, 3.842591609833387*^9},
 CellLabel->
  "Out[20]//MatrixForm=",ExpressionUUID->"1fce71fa-9867-4c5c-9481-\
f10b7572069a"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.824885151788886*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"bae5159a-521b-4194-a179-6ba48d07a108"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"u", "=", 
    RowBox[{"Array", "[", 
     RowBox[{"\[CapitalLambda]", ",", 
      RowBox[{"{", "ngdl", "}"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", "desplazamientos", " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"F", "=", 
    RowBox[{"Array", "[", 
     RowBox[{"W", ",", 
      RowBox[{"{", "ngdl", "}"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"fuerzas", " ", "en", " ", "los", " ", "nudos"}], "*)"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", "=", "1"}], ",", 
     RowBox[{"i", "\[LessEqual]", "nd"}], ",", 
     RowBox[{"i", "++"}], ",", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "1"}], ",", 
         RowBox[{"j", "\[LessEqual]", "s"}], ",", 
         RowBox[{"j", "++"}], ",", 
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"nodos", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "[", 
                RowBox[{"[", "j", "]"}], "]"}], "\[Equal]", "\"\<x\>\""}], 
              ")"}], ",", 
             RowBox[{
              RowBox[{"F", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"s", 
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}]}], "+", "j"}], "]"}], "]"}],
               "=", 
              RowBox[{
               RowBox[{
                RowBox[{"nodos", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "3", "]"}], "]"}], "[", 
               RowBox[{"[", "j", "]"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"s", 
                  RowBox[{"(", 
                   RowBox[{"i", "-", "1"}], ")"}]}], "+", "j"}], "]"}], "]"}],
               "=", 
              RowBox[{
               RowBox[{
                RowBox[{"nodos", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "[", 
               RowBox[{"[", "j", "]"}], "]"}]}]}], "]"}], ";"}], 
          "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ";"}],
       "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", "u", "]"}], " ", 
  RowBox[{"(*", "desplazamientos", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MatrixForm", "[", "F", "]"}], 
  RowBox[{"(*", "fuerzas", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.59552165608381*^9, 3.595521657069866*^9}, {
  3.5955218038092594`*^9, 3.595521876845436*^9}, {3.8248852973289304`*^9, 
  3.8248853209141083`*^9}, {3.8248853702290173`*^9, 3.824885373333248*^9}, {
  3.8248854846490707`*^9, 3.824885494998535*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"b2554c15-6a45-4e62-be35-7445bc1a0b38"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"0"},
      {"0"},
      {"0"},
      {
       RowBox[{"\[CapitalLambda]", "[", "4", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "5", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "6", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "7", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "8", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "9", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "10", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "11", "]"}]},
      {
       RowBox[{"\[CapitalLambda]", "[", "12", "]"}]},
      {"0"},
      {"0"},
      {
       RowBox[{"\[CapitalLambda]", "[", "15", "]"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.5955216464932613`*^9, 3.595521657256877*^9}, 
   3.5955218598614655`*^9, 3.595521967537624*^9, 3.595522016269411*^9, 
   3.595522963559593*^9, {3.595525828864479*^9, 3.595525837778989*^9}, 
   3.5955270845402994`*^9, 3.6103498497992373`*^9, 3.714279795348737*^9, {
   3.7142798452967367`*^9, 3.714279856137737*^9}, 3.714279956988737*^9, 
   3.7143659272277365`*^9, 3.7147124956059*^9, 3.7147126052999*^9, {
   3.747662442402594*^9, 3.7476624720135937`*^9}, {3.7476625306055937`*^9, 
   3.747662551554594*^9}, {3.747662597076194*^9, 3.747662606545394*^9}, 
   3.772466462123371*^9, 3.781844675368145*^9, {3.781845699073352*^9, 
   3.7818457100869517`*^9}, {3.800098922129445*^9, 3.8000989310854454`*^9}, 
   3.800099004072445*^9, 3.8001882788669972`*^9, 3.800764229975711*^9, {
   3.8007646591447115`*^9, 3.8007646802017117`*^9}, 3.8007647244407115`*^9, 
   3.814529385128518*^9, 3.82488520071873*^9, 3.824885340698906*^9, 
   3.8248853734886646`*^9, 3.8248854192503653`*^9, 3.8248854951584053`*^9, 
   3.824885690268612*^9, 3.8248859141482754`*^9, 3.824885998308592*^9, 
   3.8248860670981646`*^9, 3.8248861336182923`*^9, 3.8248862547455273`*^9, 
   3.8248863040783854`*^9, {3.8248863436633644`*^9, 3.8248863706396413`*^9}, 
   3.824886406814063*^9, 3.8248864625551825`*^9, 3.824886512767825*^9, 
   3.824900622052293*^9, 3.824902055396077*^9, 3.8249045830210357`*^9, 
   3.824961548133853*^9, 3.82496809403471*^9, 3.8249688730811973`*^9, 
   3.824969063409362*^9, 3.824969987425027*^9, {3.8249706197534657`*^9, 
   3.824970644612831*^9}, 3.824971111550376*^9, 3.8249713039565134`*^9, 
   3.824971581924992*^9, 3.8249717259718833`*^9, 3.824972909753113*^9, 
   3.824972977597169*^9, 3.824973093956287*^9, 3.824973462253561*^9, 
   3.824975695174926*^9, 3.82497601825311*^9, 3.8249770429564204`*^9, 
   3.824977079846857*^9, 3.8249778278781137`*^9, 3.824977888862514*^9, {
   3.8249780054252167`*^9, 3.8249780333159957`*^9}, 3.8249780895813885`*^9, 
   3.824986642300104*^9, 3.824986694893896*^9, 3.824986931643897*^9, 
   3.824987917909374*^9, 3.8249885633156357`*^9, 3.8249900715811977`*^9, 
   3.824990155222128*^9, 3.824990320753072*^9, 3.824990467268917*^9, {
   3.824990518237617*^9, 3.8249905480503597`*^9}, 3.8249905800345573`*^9, 
   3.824990750050252*^9, 3.8249907909250374`*^9, 3.824991125472125*^9, 
   3.824991161971987*^9, 3.8249912106285057`*^9, 3.8249917346597185`*^9, 
   3.8249917744093585`*^9, 3.829743397492346*^9, 3.8297436456018248`*^9, 
   3.829743712463293*^9, 3.8297437759236565`*^9, 3.829743837414633*^9, 
   3.82974393761757*^9, 3.8297440018361216`*^9, 3.8297440643362193`*^9, 
   3.829744173570896*^9, 3.829749686226856*^9, 3.8297518133361464`*^9, 
   3.829751981055282*^9, 3.829752283898652*^9, 3.829757365418584*^9, {
   3.8297574113990364`*^9, 3.829757434742505*^9}, 3.8297574716488104`*^9, 
   3.8297575661019154`*^9, 3.829757654601883*^9, {3.82975805522694*^9, 
   3.8297580701175933`*^9}, 3.8297585136018205`*^9, 3.8297591220237274`*^9, 
   3.829759361898672*^9, 3.829759432601771*^9, 3.8297597515080485`*^9, 
   3.829759822398608*^9, 3.8297598808675737`*^9, 3.82976560972683*^9, 
   3.829785772414303*^9, 3.8297864502894278`*^9, 3.8297865085240393`*^9, 
   3.8297865655395217`*^9, 3.8297866218830433`*^9, 3.8297867637584085`*^9, 
   3.8297869260714226`*^9, 3.829786984539406*^9, 3.829795299961486*^9, 
   3.829795555101971*^9, 3.829796966758387*^9, 3.8298632051986504`*^9, 
   3.8298633294016337`*^9, 3.8298633921518955`*^9, 3.8298634597612333`*^9, 
   3.8298638453395824`*^9, 3.8298646043391237`*^9, 3.8299810444665394`*^9, 
   3.8299814127790046`*^9, 3.8299822048104205`*^9, 3.8299823748572097`*^9, 
   3.8299825550761642`*^9, {3.8300549725727053`*^9, 3.8300549870917015`*^9}, 
   3.830055126944564*^9, 3.830055230310322*^9, 3.8300555634509587`*^9, 
   3.830055621722412*^9, 3.8300556705604315`*^9, 3.830058459701022*^9, 
   3.831005021766423*^9, 3.831005092806358*^9, 3.831005218896695*^9, 
   3.8310053294273663`*^9, 3.831005490986369*^9, 3.831019134459659*^9, 
   3.8388829039739637`*^9, 3.8388829927239313`*^9, 3.8388830728648458`*^9, 
   3.8388831458490257`*^9, {3.8388833661262083`*^9, 3.8388833707240767`*^9}, 
   3.838883442817865*^9, 3.8388839351926093`*^9, 3.838883966817567*^9, 
   3.8388841331522264`*^9, 3.83888442805235*^9, 3.838884480552267*^9, 
   3.8388846281145153`*^9, 3.8388853150320415`*^9, {3.838885359943659*^9, 
   3.838885410978155*^9}, {3.838885456442892*^9, 3.8388854860605707`*^9}, {
   3.838885523880163*^9, 3.838885546809617*^9}, 3.8388855854581594`*^9, 
   3.839597599041789*^9, 3.8395977096634865`*^9, 3.839597755021596*^9, 
   3.839597820435248*^9, 3.8395979024695168`*^9, 3.8395981352228565`*^9, 
   3.8395981678263464`*^9, 3.8395983220397673`*^9, 3.839598371564348*^9, {
   3.8395984045381083`*^9, 3.839598430451586*^9}, 3.83959853728452*^9, 
   3.8395986210518694`*^9, 3.839598944555665*^9, {3.8395991751243134`*^9, 
   3.8395992022096615`*^9}, 3.8395993079390955`*^9, 3.8395994034534416`*^9, 
   3.8395994902227516`*^9, {3.8395998496194735`*^9, 3.8395998669890313`*^9}, {
   3.839599919525431*^9, 3.839599969932151*^9}, 3.839600016385645*^9, 
   3.8396011306228437`*^9, 3.8396011637010775`*^9, 3.83960121976187*^9, {
   3.8396013398918858`*^9, 3.839601361347463*^9}, 3.839601505749634*^9, 
   3.8396015659199038`*^9, {3.8396016094304113`*^9, 3.839601633357763*^9}, {
   3.8396016946850443`*^9, 3.83960171717667*^9}, 3.8396017928000584`*^9, {
   3.839601850397749*^9, 3.8396019788847303`*^9}, {3.839602568722943*^9, 
   3.8396025841949644`*^9}, 3.83960264692073*^9, {3.839638428098341*^9, 
   3.8396384410449495`*^9}, {3.8396384772970524`*^9, 3.83963849221005*^9}, {
   3.8396390989360924`*^9, 3.839639157699771*^9}, 3.8396392104103184`*^9, 
   3.839639259805631*^9, {3.8396393534142637`*^9, 3.8396394070255136`*^9}, {
   3.839639699436657*^9, 3.839639723804471*^9}, 3.839639834452115*^9, {
   3.839639874016099*^9, 3.839639901737853*^9}, 3.8396452465361505`*^9, 
   3.8396453240867233`*^9, 3.8396453600952673`*^9, {3.839645401215974*^9, 
   3.839645426756826*^9}, 3.839645580924402*^9, {3.839645620136691*^9, 
   3.839645635423564*^9}, {3.8396456706108923`*^9, 3.839645689757326*^9}, {
   3.8396475154818373`*^9, 3.839647531976344*^9}, 3.8396875501989126`*^9, 
   3.839728259107757*^9, 3.8397292110311127`*^9, 3.839729669873582*^9, 
   3.8397297173615193`*^9, 3.839729753968167*^9, {3.8398596412699366`*^9, 
   3.839859663002045*^9}, {3.839859837497533*^9, 3.8398598858982*^9}, 
   3.8399427235207324`*^9, {3.839942760271033*^9, 3.8399427770989*^9}, 
   3.8399428136302843`*^9, {3.8399430185832043`*^9, 3.8399431033803873`*^9}, 
   3.8399431444271016`*^9, {3.8399432008959494`*^9, 3.8399432776926055`*^9}, 
   3.840028742857401*^9, 3.8402509703618917`*^9, 3.8402518389084735`*^9, 
   3.840251907924334*^9, {3.8402519399384165`*^9, 3.840251969353074*^9}, 
   3.840252056286069*^9, 3.8402525770960283`*^9, 3.840252658096279*^9, 
   3.8402527091115694`*^9, 3.840252740455558*^9, 3.8402530097524166`*^9, 
   3.8406651517079268`*^9, 3.8406651999958825`*^9, 3.840665293192316*^9, 
   3.8406653302081623`*^9, 3.8406665669267287`*^9, 3.840666645556314*^9, 
   3.840668083739091*^9, 3.8406681372077036`*^9, 3.840668282426484*^9, 
   3.8406683268954906`*^9, 3.842179193577092*^9, 3.842179363905208*^9, 
   3.8421805620772724`*^9, {3.8421811976711283`*^9, 3.8421812389520764`*^9}, 
   3.8421813314369125`*^9, 3.842230140733364*^9, 3.842230217030233*^9, 
   3.8422305004833956`*^9, 3.8422311446868625`*^9, 3.842232182530423*^9, 
   3.8422323227960424`*^9, 3.8422326216552277`*^9, 3.842232932483555*^9, {
   3.8422329999833174`*^9, 3.842233024717964*^9}, 3.8422330742958603`*^9, 
   3.8422331112647657`*^9, {3.842234046639618*^9, 3.842234076873936*^9}, 
   3.842234126811761*^9, {3.8422343038271627`*^9, 3.8422343203739815`*^9}, {
   3.842234365545861*^9, 3.842234402811517*^9}, {3.8422344513896933`*^9, 
   3.842234476140108*^9}, 3.842234512733697*^9, {3.842234661811552*^9, 
   3.8422347224992547`*^9}, {3.8422347684839125`*^9, 
   3.8422347835460725`*^9}, {3.8422349187334194`*^9, 3.8422349316240225`*^9}, 
   3.842235300670827*^9, 3.8422354490459814`*^9, 3.842235482468181*^9, {
   3.8422355163118114`*^9, 3.842235531780485*^9}, 3.8422355674989758`*^9, 
   3.842235610764623*^9, 3.842236423702435*^9, 3.842242210515409*^9, 
   3.842242721234095*^9, 3.842242815765485*^9, {3.842243020546583*^9, 
   3.842243040515421*^9}, 3.842243138390309*^9, 3.84224588023418*^9, 
   3.8422461746404915`*^9, 3.8422477730465593`*^9, {3.8422480581872005`*^9, 
   3.842248080343465*^9}, 3.84224879734348*^9, 3.842251313655943*^9, 
   3.8422520291720133`*^9, 3.8422529957968616`*^9, {3.842254594359277*^9, 
   3.842254609203289*^9}, 3.842254661874715*^9, 3.842266813734065*^9, 
   3.8422669870311794`*^9, {3.8422670430936794`*^9, 3.8422670590623274`*^9}, 
   3.8422698141091166`*^9, 3.8422699320782022`*^9, 3.8422706106562366`*^9, 
   3.8422709364218707`*^9, 3.842270977218652*^9, {3.8422712261561565`*^9, 
   3.84227124960944*^9}, 3.8422777280624495`*^9, 3.842319661292214*^9, 
   3.8423197154911027`*^9, 3.8423238520582905`*^9, 3.842360987470096*^9, 
   3.8423614480330176`*^9, {3.842362424407392*^9, 3.8423624431416745`*^9}, 
   3.8423672077355433`*^9, 3.8423673347045045`*^9, 3.842368208876244*^9, 
   3.842406834673341*^9, 3.8424071012973857`*^9, 3.8424105363532405`*^9, {
   3.842410592543302*^9, 3.842410614166607*^9}, 3.8424107707706594`*^9, 
   3.842411268567176*^9, 3.8424117086898947`*^9, {3.8424242389001455`*^9, 
   3.842424247696807*^9}, {3.842424490712719*^9, 3.842424512759297*^9}, 
   3.842444433462414*^9, 3.842444845384339*^9, 3.8424448808377414`*^9, 
   3.842444916541007*^9, 3.8424450749780293`*^9, 3.842445165868749*^9, {
   3.8424452043532505`*^9, 3.8424452221659865`*^9}, 3.842445254103116*^9, 
   3.8424453522440896`*^9, 3.8424454049937286`*^9, 3.8424454641657786`*^9, 
   3.842445775774996*^9, 3.842446745056216*^9, 3.8424473288375587`*^9, 
   3.842447649900031*^9, 3.842447929915847*^9, 3.842447974462891*^9, 
   3.8424481839472475`*^9, 3.842448289228112*^9, {3.842448382384307*^9, 
   3.842448401165825*^9}, {3.842448678368899*^9, 3.842448695556538*^9}, 
   3.8424489441658745`*^9, 3.8424490956503544`*^9, 3.8424492306347513`*^9, {
   3.8424493160093126`*^9, 3.842449338321884*^9}, 3.842449424118883*^9, 
   3.8424495091344757`*^9, 3.8425722392654715`*^9, {3.8425723197654095`*^9, 
   3.8425723484843407`*^9}, 3.8425725077966948`*^9, 3.842572620593526*^9, {
   3.8425727255153713`*^9, 3.842572751203105*^9}, {3.8425729912654257`*^9, 
   3.8425730182967515`*^9}, {3.8425784541677275`*^9, 3.8425784728052363`*^9}, 
   3.842578750139308*^9, 3.842578800364773*^9, 3.8425790477547197`*^9, 
   3.8425810511816034`*^9, {3.842582329772625*^9, 3.8425823510171123`*^9}, 
   3.8425824910265446`*^9, 3.842582536317508*^9, 3.8425832917818155`*^9, 
   3.8425833795206304`*^9, 3.8425834762423515`*^9, {3.842583536773454*^9, 
   3.8425835546853466`*^9}, {3.842583763367363*^9, 3.8425837729278126`*^9}, {
   3.8425838113983746`*^9, 3.842583837283845*^9}, 3.842583879771542*^9, {
   3.842584058365139*^9, 3.8425840725452003`*^9}, 3.8425842619471836`*^9, {
   3.8425843560415707`*^9, 3.842584376140991*^9}, 3.8425845981441097`*^9, 
   3.8425847121344323`*^9, 3.8425849147570887`*^9, 3.84258495216245*^9, 
   3.84258508652218*^9, {3.842585182420843*^9, 3.842585196837827*^9}, 
   3.8425913362729397`*^9, 3.8425914654928246`*^9, 3.8425916098782606`*^9},
 CellLabel->
  "Out[25]//MatrixForm=",ExpressionUUID->"922ffe88-2ba4-447f-ba9f-\
0c0c82152a64"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"W", "[", "1", "]"}]},
      {
       RowBox[{"W", "[", "2", "]"}]},
      {
       RowBox[{"W", "[", "3", "]"}]},
      {"0"},
      {"0"},
      {"0"},
      {"0"},
      {
       RowBox[{"-", "P"}]},
      {"0"},
      {
       FractionBox["P", "6"]},
      {"0"},
      {"0"},
      {
       RowBox[{"W", "[", "13", "]"}]},
      {
       RowBox[{"W", "[", "14", "]"}]},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.5955216464932613`*^9, 3.595521657256877*^9}, 
   3.5955218598614655`*^9, 3.595521967537624*^9, 3.595522016269411*^9, 
   3.595522963559593*^9, {3.595525828864479*^9, 3.595525837778989*^9}, 
   3.5955270845402994`*^9, 3.6103498497992373`*^9, 3.714279795348737*^9, {
   3.7142798452967367`*^9, 3.714279856137737*^9}, 3.714279956988737*^9, 
   3.7143659272277365`*^9, 3.7147124956059*^9, 3.7147126052999*^9, {
   3.747662442402594*^9, 3.7476624720135937`*^9}, {3.7476625306055937`*^9, 
   3.747662551554594*^9}, {3.747662597076194*^9, 3.747662606545394*^9}, 
   3.772466462123371*^9, 3.781844675368145*^9, {3.781845699073352*^9, 
   3.7818457100869517`*^9}, {3.800098922129445*^9, 3.8000989310854454`*^9}, 
   3.800099004072445*^9, 3.8001882788669972`*^9, 3.800764229975711*^9, {
   3.8007646591447115`*^9, 3.8007646802017117`*^9}, 3.8007647244407115`*^9, 
   3.814529385128518*^9, 3.82488520071873*^9, 3.824885340698906*^9, 
   3.8248853734886646`*^9, 3.8248854192503653`*^9, 3.8248854951584053`*^9, 
   3.824885690268612*^9, 3.8248859141482754`*^9, 3.824885998308592*^9, 
   3.8248860670981646`*^9, 3.8248861336182923`*^9, 3.8248862547455273`*^9, 
   3.8248863040783854`*^9, {3.8248863436633644`*^9, 3.8248863706396413`*^9}, 
   3.824886406814063*^9, 3.8248864625551825`*^9, 3.824886512767825*^9, 
   3.824900622052293*^9, 3.824902055396077*^9, 3.8249045830210357`*^9, 
   3.824961548133853*^9, 3.82496809403471*^9, 3.8249688730811973`*^9, 
   3.824969063409362*^9, 3.824969987425027*^9, {3.8249706197534657`*^9, 
   3.824970644612831*^9}, 3.824971111550376*^9, 3.8249713039565134`*^9, 
   3.824971581924992*^9, 3.8249717259718833`*^9, 3.824972909753113*^9, 
   3.824972977597169*^9, 3.824973093956287*^9, 3.824973462253561*^9, 
   3.824975695174926*^9, 3.82497601825311*^9, 3.8249770429564204`*^9, 
   3.824977079846857*^9, 3.8249778278781137`*^9, 3.824977888862514*^9, {
   3.8249780054252167`*^9, 3.8249780333159957`*^9}, 3.8249780895813885`*^9, 
   3.824986642300104*^9, 3.824986694893896*^9, 3.824986931643897*^9, 
   3.824987917909374*^9, 3.8249885633156357`*^9, 3.8249900715811977`*^9, 
   3.824990155222128*^9, 3.824990320753072*^9, 3.824990467268917*^9, {
   3.824990518237617*^9, 3.8249905480503597`*^9}, 3.8249905800345573`*^9, 
   3.824990750050252*^9, 3.8249907909250374`*^9, 3.824991125472125*^9, 
   3.824991161971987*^9, 3.8249912106285057`*^9, 3.8249917346597185`*^9, 
   3.8249917744093585`*^9, 3.829743397492346*^9, 3.8297436456018248`*^9, 
   3.829743712463293*^9, 3.8297437759236565`*^9, 3.829743837414633*^9, 
   3.82974393761757*^9, 3.8297440018361216`*^9, 3.8297440643362193`*^9, 
   3.829744173570896*^9, 3.829749686226856*^9, 3.8297518133361464`*^9, 
   3.829751981055282*^9, 3.829752283898652*^9, 3.829757365418584*^9, {
   3.8297574113990364`*^9, 3.829757434742505*^9}, 3.8297574716488104`*^9, 
   3.8297575661019154`*^9, 3.829757654601883*^9, {3.82975805522694*^9, 
   3.8297580701175933`*^9}, 3.8297585136018205`*^9, 3.8297591220237274`*^9, 
   3.829759361898672*^9, 3.829759432601771*^9, 3.8297597515080485`*^9, 
   3.829759822398608*^9, 3.8297598808675737`*^9, 3.82976560972683*^9, 
   3.829785772414303*^9, 3.8297864502894278`*^9, 3.8297865085240393`*^9, 
   3.8297865655395217`*^9, 3.8297866218830433`*^9, 3.8297867637584085`*^9, 
   3.8297869260714226`*^9, 3.829786984539406*^9, 3.829795299961486*^9, 
   3.829795555101971*^9, 3.829796966758387*^9, 3.8298632051986504`*^9, 
   3.8298633294016337`*^9, 3.8298633921518955`*^9, 3.8298634597612333`*^9, 
   3.8298638453395824`*^9, 3.8298646043391237`*^9, 3.8299810444665394`*^9, 
   3.8299814127790046`*^9, 3.8299822048104205`*^9, 3.8299823748572097`*^9, 
   3.8299825550761642`*^9, {3.8300549725727053`*^9, 3.8300549870917015`*^9}, 
   3.830055126944564*^9, 3.830055230310322*^9, 3.8300555634509587`*^9, 
   3.830055621722412*^9, 3.8300556705604315`*^9, 3.830058459701022*^9, 
   3.831005021766423*^9, 3.831005092806358*^9, 3.831005218896695*^9, 
   3.8310053294273663`*^9, 3.831005490986369*^9, 3.831019134459659*^9, 
   3.8388829039739637`*^9, 3.8388829927239313`*^9, 3.8388830728648458`*^9, 
   3.8388831458490257`*^9, {3.8388833661262083`*^9, 3.8388833707240767`*^9}, 
   3.838883442817865*^9, 3.8388839351926093`*^9, 3.838883966817567*^9, 
   3.8388841331522264`*^9, 3.83888442805235*^9, 3.838884480552267*^9, 
   3.8388846281145153`*^9, 3.8388853150320415`*^9, {3.838885359943659*^9, 
   3.838885410978155*^9}, {3.838885456442892*^9, 3.8388854860605707`*^9}, {
   3.838885523880163*^9, 3.838885546809617*^9}, 3.8388855854581594`*^9, 
   3.839597599041789*^9, 3.8395977096634865`*^9, 3.839597755021596*^9, 
   3.839597820435248*^9, 3.8395979024695168`*^9, 3.8395981352228565`*^9, 
   3.8395981678263464`*^9, 3.8395983220397673`*^9, 3.839598371564348*^9, {
   3.8395984045381083`*^9, 3.839598430451586*^9}, 3.83959853728452*^9, 
   3.8395986210518694`*^9, 3.839598944555665*^9, {3.8395991751243134`*^9, 
   3.8395992022096615`*^9}, 3.8395993079390955`*^9, 3.8395994034534416`*^9, 
   3.8395994902227516`*^9, {3.8395998496194735`*^9, 3.8395998669890313`*^9}, {
   3.839599919525431*^9, 3.839599969932151*^9}, 3.839600016385645*^9, 
   3.8396011306228437`*^9, 3.8396011637010775`*^9, 3.83960121976187*^9, {
   3.8396013398918858`*^9, 3.839601361347463*^9}, 3.839601505749634*^9, 
   3.8396015659199038`*^9, {3.8396016094304113`*^9, 3.839601633357763*^9}, {
   3.8396016946850443`*^9, 3.83960171717667*^9}, 3.8396017928000584`*^9, {
   3.839601850397749*^9, 3.8396019788847303`*^9}, {3.839602568722943*^9, 
   3.8396025841949644`*^9}, 3.83960264692073*^9, {3.839638428098341*^9, 
   3.8396384410449495`*^9}, {3.8396384772970524`*^9, 3.83963849221005*^9}, {
   3.8396390989360924`*^9, 3.839639157699771*^9}, 3.8396392104103184`*^9, 
   3.839639259805631*^9, {3.8396393534142637`*^9, 3.8396394070255136`*^9}, {
   3.839639699436657*^9, 3.839639723804471*^9}, 3.839639834452115*^9, {
   3.839639874016099*^9, 3.839639901737853*^9}, 3.8396452465361505`*^9, 
   3.8396453240867233`*^9, 3.8396453600952673`*^9, {3.839645401215974*^9, 
   3.839645426756826*^9}, 3.839645580924402*^9, {3.839645620136691*^9, 
   3.839645635423564*^9}, {3.8396456706108923`*^9, 3.839645689757326*^9}, {
   3.8396475154818373`*^9, 3.839647531976344*^9}, 3.8396875501989126`*^9, 
   3.839728259107757*^9, 3.8397292110311127`*^9, 3.839729669873582*^9, 
   3.8397297173615193`*^9, 3.839729753968167*^9, {3.8398596412699366`*^9, 
   3.839859663002045*^9}, {3.839859837497533*^9, 3.8398598858982*^9}, 
   3.8399427235207324`*^9, {3.839942760271033*^9, 3.8399427770989*^9}, 
   3.8399428136302843`*^9, {3.8399430185832043`*^9, 3.8399431033803873`*^9}, 
   3.8399431444271016`*^9, {3.8399432008959494`*^9, 3.8399432776926055`*^9}, 
   3.840028742857401*^9, 3.8402509703618917`*^9, 3.8402518389084735`*^9, 
   3.840251907924334*^9, {3.8402519399384165`*^9, 3.840251969353074*^9}, 
   3.840252056286069*^9, 3.8402525770960283`*^9, 3.840252658096279*^9, 
   3.8402527091115694`*^9, 3.840252740455558*^9, 3.8402530097524166`*^9, 
   3.8406651517079268`*^9, 3.8406651999958825`*^9, 3.840665293192316*^9, 
   3.8406653302081623`*^9, 3.8406665669267287`*^9, 3.840666645556314*^9, 
   3.840668083739091*^9, 3.8406681372077036`*^9, 3.840668282426484*^9, 
   3.8406683268954906`*^9, 3.842179193577092*^9, 3.842179363905208*^9, 
   3.8421805620772724`*^9, {3.8421811976711283`*^9, 3.8421812389520764`*^9}, 
   3.8421813314369125`*^9, 3.842230140733364*^9, 3.842230217030233*^9, 
   3.8422305004833956`*^9, 3.8422311446868625`*^9, 3.842232182530423*^9, 
   3.8422323227960424`*^9, 3.8422326216552277`*^9, 3.842232932483555*^9, {
   3.8422329999833174`*^9, 3.842233024717964*^9}, 3.8422330742958603`*^9, 
   3.8422331112647657`*^9, {3.842234046639618*^9, 3.842234076873936*^9}, 
   3.842234126811761*^9, {3.8422343038271627`*^9, 3.8422343203739815`*^9}, {
   3.842234365545861*^9, 3.842234402811517*^9}, {3.8422344513896933`*^9, 
   3.842234476140108*^9}, 3.842234512733697*^9, {3.842234661811552*^9, 
   3.8422347224992547`*^9}, {3.8422347684839125`*^9, 
   3.8422347835460725`*^9}, {3.8422349187334194`*^9, 3.8422349316240225`*^9}, 
   3.842235300670827*^9, 3.8422354490459814`*^9, 3.842235482468181*^9, {
   3.8422355163118114`*^9, 3.842235531780485*^9}, 3.8422355674989758`*^9, 
   3.842235610764623*^9, 3.842236423702435*^9, 3.842242210515409*^9, 
   3.842242721234095*^9, 3.842242815765485*^9, {3.842243020546583*^9, 
   3.842243040515421*^9}, 3.842243138390309*^9, 3.84224588023418*^9, 
   3.8422461746404915`*^9, 3.8422477730465593`*^9, {3.8422480581872005`*^9, 
   3.842248080343465*^9}, 3.84224879734348*^9, 3.842251313655943*^9, 
   3.8422520291720133`*^9, 3.8422529957968616`*^9, {3.842254594359277*^9, 
   3.842254609203289*^9}, 3.842254661874715*^9, 3.842266813734065*^9, 
   3.8422669870311794`*^9, {3.8422670430936794`*^9, 3.8422670590623274`*^9}, 
   3.8422698141091166`*^9, 3.8422699320782022`*^9, 3.8422706106562366`*^9, 
   3.8422709364218707`*^9, 3.842270977218652*^9, {3.8422712261561565`*^9, 
   3.84227124960944*^9}, 3.8422777280624495`*^9, 3.842319661292214*^9, 
   3.8423197154911027`*^9, 3.8423238520582905`*^9, 3.842360987470096*^9, 
   3.8423614480330176`*^9, {3.842362424407392*^9, 3.8423624431416745`*^9}, 
   3.8423672077355433`*^9, 3.8423673347045045`*^9, 3.842368208876244*^9, 
   3.842406834673341*^9, 3.8424071012973857`*^9, 3.8424105363532405`*^9, {
   3.842410592543302*^9, 3.842410614166607*^9}, 3.8424107707706594`*^9, 
   3.842411268567176*^9, 3.8424117086898947`*^9, {3.8424242389001455`*^9, 
   3.842424247696807*^9}, {3.842424490712719*^9, 3.842424512759297*^9}, 
   3.842444433462414*^9, 3.842444845384339*^9, 3.8424448808377414`*^9, 
   3.842444916541007*^9, 3.8424450749780293`*^9, 3.842445165868749*^9, {
   3.8424452043532505`*^9, 3.8424452221659865`*^9}, 3.842445254103116*^9, 
   3.8424453522440896`*^9, 3.8424454049937286`*^9, 3.8424454641657786`*^9, 
   3.842445775774996*^9, 3.842446745056216*^9, 3.8424473288375587`*^9, 
   3.842447649900031*^9, 3.842447929915847*^9, 3.842447974462891*^9, 
   3.8424481839472475`*^9, 3.842448289228112*^9, {3.842448382384307*^9, 
   3.842448401165825*^9}, {3.842448678368899*^9, 3.842448695556538*^9}, 
   3.8424489441658745`*^9, 3.8424490956503544`*^9, 3.8424492306347513`*^9, {
   3.8424493160093126`*^9, 3.842449338321884*^9}, 3.842449424118883*^9, 
   3.8424495091344757`*^9, 3.8425722392654715`*^9, {3.8425723197654095`*^9, 
   3.8425723484843407`*^9}, 3.8425725077966948`*^9, 3.842572620593526*^9, {
   3.8425727255153713`*^9, 3.842572751203105*^9}, {3.8425729912654257`*^9, 
   3.8425730182967515`*^9}, {3.8425784541677275`*^9, 3.8425784728052363`*^9}, 
   3.842578750139308*^9, 3.842578800364773*^9, 3.8425790477547197`*^9, 
   3.8425810511816034`*^9, {3.842582329772625*^9, 3.8425823510171123`*^9}, 
   3.8425824910265446`*^9, 3.842582536317508*^9, 3.8425832917818155`*^9, 
   3.8425833795206304`*^9, 3.8425834762423515`*^9, {3.842583536773454*^9, 
   3.8425835546853466`*^9}, {3.842583763367363*^9, 3.8425837729278126`*^9}, {
   3.8425838113983746`*^9, 3.842583837283845*^9}, 3.842583879771542*^9, {
   3.842584058365139*^9, 3.8425840725452003`*^9}, 3.8425842619471836`*^9, {
   3.8425843560415707`*^9, 3.842584376140991*^9}, 3.8425845981441097`*^9, 
   3.8425847121344323`*^9, 3.8425849147570887`*^9, 3.84258495216245*^9, 
   3.84258508652218*^9, {3.842585182420843*^9, 3.842585196837827*^9}, 
   3.8425913362729397`*^9, 3.8425914654928246`*^9, 3.842591609883303*^9},
 CellLabel->
  "Out[26]//MatrixForm=",ExpressionUUID->"292d52cc-3ea9-4e69-b0aa-\
2344c7f22866"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"orden", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", 
    RowBox[{"i", "<=", "ngdl"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "==", "0.0"}], ",", 
      RowBox[{"orden", "++"}]}], "]"}]}], "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"cono", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "orden", "}"}]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"gdl", " ", "conocidos"}], "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"i", "=", "1"}], ";", 
     RowBox[{"a", "=", "1"}]}], ",", 
    RowBox[{"i", "<=", "ngdl"}], ",", 
    RowBox[{"i", "++"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "==", "0.0"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"Part", "[", 
          RowBox[{"cono", ",", "a"}], "]"}], "=", "i"}], ",", 
        RowBox[{"a", "++"}]}], "}"}]}], "]"}]}], "]"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"kk", "=", 
   RowBox[{"Table", "[", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "ngdl"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"incog", "=", 
  RowBox[{"Complement", "[", 
   RowBox[{"kk", ",", " ", "cono"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{"gdl", " ", "incognita"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.8248857481786947`*^9, 3.8248857738783617`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"9258be79-c3e3-4d36-90b0-abe8e0b99de1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "5", ",", "6", ",", "7", ",", "8", ",", "9", ",", "10", ",", "11",
    ",", "12", ",", "15"}], "}"}]], "Output",
 CellChangeTimes->{{3.824885742563437*^9, 3.8248857571786833`*^9}, 
   3.824885914208475*^9, 3.8248859983784385`*^9, 3.8248860671682673`*^9, 
   3.824886133683365*^9, 3.824886254797388*^9, 3.8248863041280384`*^9, {
   3.824886343707958*^9, 3.824886370687562*^9}, 3.8248864068595304`*^9, 
   3.824886462600004*^9, 3.8248865128181334`*^9, 3.8249006220990267`*^9, 
   3.8249020554585905`*^9, 3.824904583068107*^9, 3.8249615481884623`*^9, 
   3.824968099581478*^9, 3.824968873144102*^9, 3.8249690634718947`*^9, 
   3.824969987471922*^9, {3.824970619800283*^9, 3.824970644659655*^9}, 
   3.8249711116438684`*^9, 3.8249713070812187`*^9, 3.8249715819874897`*^9, 
   3.8249717260343924`*^9, 3.8249729098000717`*^9, 3.8249729776750145`*^9, 
   3.8249730940033026`*^9, 3.8249734623159466`*^9, 3.8249757008312397`*^9, 
   3.824976018362563*^9, 3.824977043065646*^9, 3.82497707995662*^9, 
   3.824977827987509*^9, 3.8249778889720125`*^9, {3.8249780055191755`*^9, 
   3.8249780334564147`*^9}, 3.8249780896438003`*^9, 3.8249866423316464`*^9, 
   3.824986694971853*^9, 3.8249869316908984`*^9, 3.8249879179564905`*^9, 
   3.8249885633781853`*^9, 3.8249900716282887`*^9, 3.8249901552688913`*^9, 
   3.824990324940792*^9, 3.824990467300029*^9, {3.8249905182689857`*^9, 
   3.8249905480971613`*^9}, 3.82499058006569*^9, 3.824990750128436*^9, 
   3.8249907909719*^9, 3.8249911255191746`*^9, 3.8249911620187683`*^9, 
   3.8249912106752396`*^9, 3.82499173469073*^9, 3.824991774456395*^9, 
   3.829743397539425*^9, 3.8297436456486845`*^9, 3.82974371252357*^9, 
   3.829743775992795*^9, 3.8297438374618196`*^9, 3.829743937680094*^9, 
   3.8297440018986597`*^9, 3.829744064398559*^9, 3.829744173622903*^9, 
   3.8297496863208933`*^9, 3.829751813398962*^9, 3.8297519811331887`*^9, 
   3.8297522839299426`*^9, 3.8297573654613686`*^9, {3.82975741145432*^9, 
   3.82975743480515*^9}, 3.829757471695619*^9, 3.8297575661643386`*^9, 
   3.8297576546642833`*^9, {3.8297580552842774`*^9, 3.829758070180159*^9}, 
   3.8297585136664896`*^9, 3.829759122096797*^9, 3.8297593619766855`*^9, 
   3.829759432679817*^9, 3.829759751570857*^9, 3.8297598224443846`*^9, 
   3.8297598809302588`*^9, 3.8297656098093643`*^9, 3.829785772507992*^9, 
   3.8297864503295836`*^9, 3.829786508570462*^9, 3.8297865655550437`*^9, 
   3.829786622711917*^9, 3.8297867638049035`*^9, 3.8297869261332617`*^9, 
   3.829786984601964*^9, 3.829795300024006*^9, 3.8297955551490393`*^9, 
   3.8297969668205376`*^9, 3.829863205261153*^9, 3.829863329448823*^9, 
   3.8298633922144685`*^9, 3.829863459823535*^9, 3.829863845401884*^9, 
   3.82986460441115*^9, 3.829981044638342*^9, 3.8299814128262267`*^9, 
   3.8299822048730984`*^9, 3.829982374935279*^9, 3.8299825551383657`*^9, {
   3.8300549726230507`*^9, 3.8300549871384616`*^9}, 3.830055126982323*^9, 
   3.8300552303729343`*^9, 3.8300555635134106`*^9, 3.8300556217636023`*^9, 
   3.830055670644497*^9, 3.83005845977927*^9, 3.8310050218265204`*^9, 
   3.831005092851308*^9, 3.8310052189463873`*^9, 3.8310053294464684`*^9, 
   3.8310054910512943`*^9, 3.831019134499103*^9, 3.838882904098818*^9, 
   3.8388829927864313`*^9, 3.838883072926893*^9, 3.8388831459117002`*^9, 
   3.838883370817542*^9, 3.8388834429273367`*^9, 3.838883935255155*^9, 
   3.8388839668800526`*^9, 3.838884133208173*^9, 3.8388844281302605`*^9, 
   3.838884480630186*^9, 3.8388846281616216`*^9, 3.838885315067813*^9, {
   3.8388853599894447`*^9, 3.838885411020915*^9}, {3.8388854564894867`*^9, 
   3.838885486099809*^9}, {3.8388855239269595`*^9, 3.838885546848939*^9}, 
   3.838885585507641*^9, 3.83959760270187*^9, 3.8395977097071433`*^9, 
   3.8395977550819855`*^9, 3.839597820481536*^9, 3.8395979025431433`*^9, 
   3.839598135289973*^9, 3.8395981678973923`*^9, 3.8395983221265817`*^9, 
   3.839598371637498*^9, {3.839598404619747*^9, 3.8395984305085144`*^9}, 
   3.8395985373284225`*^9, 3.8395986211111317`*^9, 3.8395989445911655`*^9, {
   3.8395991751848426`*^9, 3.83959920227246*^9}, 3.8395993079979067`*^9, 
   3.8395994035284967`*^9, 3.839599490300479*^9, {3.839599849667856*^9, 
   3.8395998670444994`*^9}, {3.8395999195617757`*^9, 3.839599969971041*^9}, 
   3.839600016451705*^9, 3.839601130653824*^9, 3.839601163760951*^9, 
   3.8396012197963486`*^9, {3.839601339963215*^9, 3.8396013613813405`*^9}, 
   3.8396015057994356`*^9, 3.839601565972982*^9, {3.8396016094929724`*^9, 
   3.8396016334215937`*^9}, {3.8396016947183237`*^9, 3.8396017172361784`*^9}, 
   3.8396017928649163`*^9, {3.8396018504695444`*^9, 3.8396019789455123`*^9}, {
   3.8396025687859917`*^9, 3.839602584257797*^9}, 3.8396026469662757`*^9, {
   3.8396384281403003`*^9, 3.8396384410868373`*^9}, {3.8396384773394146`*^9, 
   3.839638492250963*^9}, {3.839639098981948*^9, 3.8396391577511964`*^9}, 
   3.8396392104630365`*^9, 3.839639259857642*^9, {3.8396393534734936`*^9, 
   3.839639407071391*^9}, {3.8396396994731464`*^9, 3.8396397238567314`*^9}, 
   3.839639834518261*^9, {3.839639874050745*^9, 3.8396399018049154`*^9}, 
   3.8396452465959353`*^9, 3.8396453241524873`*^9, 3.839645360163067*^9, {
   3.8396454012486773`*^9, 3.839645426816743*^9}, 3.8396455809801645`*^9, {
   3.8396456201973886`*^9, 3.839645635485426*^9}, {3.839645670668718*^9, 
   3.839645689822878*^9}, {3.8396475155418844`*^9, 3.8396475320376263`*^9}, 
   3.839687550286701*^9, 3.8397282591765327`*^9, 3.839729211067734*^9, 
   3.8397296699373617`*^9, 3.83972971741088*^9, 3.8397297540133915`*^9, {
   3.839859641338749*^9, 3.8398596630752196`*^9}, {3.8398598375500846`*^9, 
   3.83985988597401*^9}, 3.839942723755249*^9, {3.839942760317788*^9, 
   3.839942777161273*^9}, 3.8399428136771584`*^9, {3.839943018630209*^9, 
   3.8399431034273224`*^9}, 3.839943144505451*^9, {3.839943200947075*^9, 
   3.839943277708229*^9}, 3.8400287429041967`*^9, 3.8402509704201546`*^9, 
   3.8402518389710817`*^9, 3.8402519079555707`*^9, {3.8402519400023727`*^9, 
   3.840251969408882*^9}, 3.8402520563464155`*^9, 3.8402525771523495`*^9, 
   3.8402526581431856`*^9, 3.8402527091428123`*^9, 3.8402527405181465`*^9, 
   3.840253009783498*^9, 3.8406651517599053`*^9, 3.840665200036139*^9, 
   3.8406652932548466`*^9, 3.840665330239411*^9, 3.8406665669735985`*^9, 
   3.8406666456140847`*^9, 3.8406680837858477`*^9, 3.840668137255028*^9, 
   3.8406682824577312`*^9, 3.840668326942396*^9, 3.8421792029521713`*^9, 
   3.8421793639677672`*^9, 3.84218056557724*^9, {3.842181197717766*^9, 
   3.842181239014584*^9}, 3.8421813314834557`*^9, {3.8423196995411267`*^9, 
   3.842319715522333*^9}, 3.8423238521208067`*^9, 3.8423609875170918`*^9, 
   3.8423614480792217`*^9, {3.842362424438733*^9, 3.842362443188818*^9}, 
   3.8423672077825513`*^9, 3.8423673347512054`*^9, 3.842368208938642*^9, 
   3.8424068347287717`*^9, 3.8424071013598957`*^9, 3.842410536415694*^9, {
   3.8424105926058006`*^9, 3.8424106142447147`*^9}, 3.8424107708331437`*^9, 
   3.8424112686353793`*^9, 3.8424117087367587`*^9, {3.842424238947245*^9, 
   3.842424247743763*^9}, {3.8424244907595763`*^9, 3.842424512806348*^9}, 
   3.842444433493701*^9, 3.842444845431342*^9, 3.8424448808689528`*^9, 
   3.8424449165722356`*^9, 3.842445075040928*^9, 3.8424451659160423`*^9, {
   3.84244520438465*^9, 3.8424452222126255`*^9}, 3.842445254149932*^9, 
   3.842445352275397*^9, 3.842445405040598*^9, 3.8424454641968465`*^9, 
   3.8424457758221025`*^9, 3.8424467450875754`*^9, 3.842447328884327*^9, 
   3.8424476499468346`*^9, 3.8424479299628286`*^9, 3.842447974509655*^9, 
   3.842448183993823*^9, 3.8424482892753167`*^9, {3.842448382431176*^9, 
   3.84244840121273*^9}, {3.842448678400364*^9, 3.8424486955874596`*^9}, 
   3.842448944212758*^9, 3.842449095712557*^9, 3.8424492306815805`*^9, {
   3.8424493160721827`*^9, 3.8424493384936934`*^9}, 3.8424494241656494`*^9, 
   3.842449509165593*^9, 3.842572239296672*^9, {3.8425723198123183`*^9, 
   3.8425723485155497`*^9}, 3.842572507843521*^9, 3.8425726206405087`*^9, {
   3.8425727255625124`*^9, 3.8425727512342043`*^9}, {3.8425729913280087`*^9, 
   3.842573018343749*^9}, {3.84257845421459*^9, 3.842578472852101*^9}, 
   3.8425787501705236`*^9, 3.842578800416367*^9, 3.8425790477859416`*^9, 
   3.84258106077314*^9, {3.842582311789549*^9, 3.8425823510639496`*^9}, 
   3.842582491073408*^9, 3.8425825363535347`*^9, 3.842583291828659*^9, 
   3.8425833795648937`*^9, 3.8425834762689962`*^9, {3.8425835368047004`*^9, 
   3.842583554716587*^9}, {3.8425837633986044`*^9, 3.8425837729746523`*^9}, {
   3.842583811429646*^9, 3.8425838373420167`*^9}, 3.8425838798126106`*^9, {
   3.842584058396408*^9, 3.8425840725920467`*^9}, 3.842584261994047*^9, {
   3.842584356086193*^9, 3.8425843761878552`*^9}, 3.8425845981951237`*^9, 
   3.8425847121656723`*^9, 3.842584914803953*^9, 3.84258495220401*^9, 
   3.8425850865690517`*^9, {3.8425851824677114`*^9, 3.842585196884719*^9}, 
   3.8425913363128395`*^9, 3.8425914655280466`*^9, 3.842591609923188*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"54d2cea6-7948-4636-95e5-b44ee0b7147b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MatrixForm", "[", 
   RowBox[{"Feqv", "+", "F"}], "]"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{
  3.824885739448489*^9, {3.8422459473592615`*^9, 3.8422459777343283`*^9}, 
   3.8425821967654424`*^9, 3.8425822346075664`*^9, {3.8425823647639008`*^9, 
   3.8425824106126475`*^9}, {3.8425824872113266`*^9, 3.8425824896171403`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"9aa016e4-032f-40d2-b2fa-b2bc7f782a0e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "1"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"W", "[", "1", "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}], "+", 
        RowBox[{"W", "[", "2", "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "1"}], "]"}], "+", 
        RowBox[{"W", "[", "3", "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"1", ",", "1"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "2"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "1", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "2"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "2"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "2", "]"}]}], "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", "P", "+", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "2"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "3"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "3"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "3"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        FractionBox["P", "6"], "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "4"}], "]"}]}], "-", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}], "-", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "4", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "3"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "4"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "4"}], "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "4"}], "]"}], "+", 
           RowBox[{"Mz", "[", 
            RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}], "+", 
        RowBox[{"W", "[", "13", "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"1.`", " ", 
         RowBox[{"Nx", "[", "3", "]"}]}], "+", 
        RowBox[{"W", "[", "14", "]"}]}]},
      {
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "5"}], "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8422459534376154`*^9, 3.842245977999971*^9}, 
   3.8422461747028675`*^9, 3.842247773124916*^9, {3.8422480582497745`*^9, 
   3.8422480803903327`*^9}, 3.8422487973903613`*^9, 3.8422513137032704`*^9, 
   3.842252033249724*^9, 3.842252086031268*^9, 3.842252995859129*^9, {
   3.842254594406061*^9, 3.842254609265789*^9}, 3.8422546619215717`*^9, 
   3.842266813796906*^9, 3.842266987062272*^9, {3.842267043155963*^9, 
   3.842267059093498*^9}, 3.8422698179999294`*^9, 3.842269932124977*^9, 
   3.842270610703066*^9, 3.842270936468588*^9, 3.8422709772811418`*^9, {
   3.8422712262030573`*^9, 3.8422712496562557`*^9}, 3.842277737124829*^9, 
   3.8423196613427253`*^9, 3.842319715584819*^9, 3.8423238521832933`*^9, 
   3.8423609875322447`*^9, 3.842361448095106*^9, {3.8423624244857807`*^9, 
   3.8423624442984385`*^9}, 3.8423672078295555`*^9, 3.8423673347980366`*^9, 
   3.8423682089854174`*^9, 3.842406834775649*^9, 3.8424071014223843`*^9, 
   3.842410536478211*^9, {3.8424105926683073`*^9, 3.842410614322853*^9}, 
   3.842410770895633*^9, 3.8424112686878033`*^9, 3.8424117088148985`*^9, {
   3.842424239009675*^9, 3.842424247806169*^9}, {3.8424244907752924`*^9, 
   3.8424245128220053`*^9}, 3.842444433540887*^9, 3.8424448454937105`*^9, 
   3.8424448809316225`*^9, 3.842444916619018*^9, 3.8424450750876236`*^9, 
   3.842445165931636*^9, {3.842445204431264*^9, 3.8424452222751565`*^9}, 
   3.842445254212719*^9, 3.842445352321915*^9, 3.8424454050561895`*^9, 
   3.8424454642593317`*^9, 3.8424457758376803`*^9, 3.842446745134409*^9, 
   3.84244732894715*^9, 3.8424476500097165`*^9, 3.8424479299784536`*^9, 
   3.8424479745718894`*^9, 3.8424481840565042`*^9, 3.8424482893377914`*^9, {
   3.842448382493774*^9, 3.8424484012752657`*^9}, {3.8424486784471893`*^9, 
   3.842448695634327*^9}, 3.842448944274927*^9, 3.8424490957282133`*^9, 
   3.842449230728401*^9, {3.8424493161032095`*^9, 3.8424493385718184`*^9}, 
   3.8424494241969223`*^9, 3.8424495092127934`*^9, 3.842572239312354*^9, {
   3.842572319859229*^9, 3.8425723485625553`*^9}, 3.8425725078591795`*^9, 
   3.842572620656142*^9, {3.8425727256092525`*^9, 3.8425727512812405`*^9}, {
   3.8425729913748903`*^9, 3.8425730184059563`*^9}, {3.8425784542614555`*^9, 
   3.842578472867717*^9}, 3.8425787502330356`*^9, 3.842578800478855*^9, 
   3.842579047849683*^9, 3.8425810633350115`*^9, 3.8425821969685087`*^9, 
   3.8425822352792797`*^9, {3.842582329862258*^9, 3.8425823721683855`*^9}, 
   3.842582410768819*^9, 3.842582491120272*^9, 3.8425825364004297`*^9, 
   3.842583291875524*^9, 3.8425833796117578`*^9, 3.8425834763182864`*^9, {
   3.8425835368515615`*^9, 3.842583554763482*^9}, {3.842583763445438*^9, 
   3.8425837730215483`*^9}, {3.8425838114764786`*^9, 3.842583837388908*^9}, 
   3.842583879843874*^9, {3.842584058458865*^9, 3.8425840726389136`*^9}, 
   3.8425842620305376`*^9, {3.8425843561330247`*^9, 3.84258437623472*^9}, 
   3.842584598257613*^9, 3.8425847121949215`*^9, 3.8425849148492575`*^9, 
   3.842584952250874*^9, 3.8425850866159163`*^9, {3.8425851824989214`*^9, 
   3.8425851969315815`*^9}, 3.8425913363580112`*^9, 3.8425914655782585`*^9, 
   3.8425916099484425`*^9},
 CellLabel->
  "Out[33]//MatrixForm=",ExpressionUUID->"8f3cd6e5-814a-4cb6-b482-\
0655eb7b7246"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"kk", "=", 
   RowBox[{"Feqv", "+", "F"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ecs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"kk", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "kk", "]"}]}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{3.8425824803638268`*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"2069ffb2-65a9-4825-94b5-e42e64dfe1f9"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.8425814159380274`*^9, 3.8425825449592543`*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"8557a313-470c-431e-a925-239053f8ba6c"],

Cell[BoxData[
 RowBox[{"(*", " ", "sistematizar", " ", "*)"}]], "Input",
 CellChangeTimes->{{3.842581417156499*^9, 3.842581422717704*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"691f5174-c742-4651-b796-68e6e7838f6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"axil", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"ecs", "[", 
      RowBox[{"[", 
       RowBox[{"{", 
        RowBox[{"5", ",", "7", ",", "10", ",", "11"}], "}"}], "]"}], "]"}], 
     ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Nx", "[", "b", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "nb"}], "}"}]}], "]"}]}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.842583674646714*^9, 3.842583719382327*^9}, {
  3.8425838881232023`*^9, 3.8425838886543283`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"dffc14e1-f2df-4f3f-849e-42ee6aff5afe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Nx", "[", "1", "]"}], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.2`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "2"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"Nx", "[", "2", "]"}], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"(", 
       RowBox[{"0.`", "\[VeryThinSpace]", "+", 
        RowBox[{"0.16666666666666666`", " ", "P"}], "-", 
        RowBox[{"0.2`", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1.`"}], " ", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "4"}], "]"}]}], "-", 
           RowBox[{"1.`", " ", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "5"}], "]"}]}]}], ")"}]}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"Nx", "[", "3", "]"}], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.2`", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "3"}], "]"}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}]}], ",", 
   RowBox[{
    RowBox[{"Nx", "[", "4", "]"}], "\[Rule]", 
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.16666666666666666`", " ", "P"}], "+", 
     RowBox[{"0.2`", " ", 
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "4"}], "]"}]}], "+", 
     RowBox[{"0.2`", " ", 
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "5"}], "]"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.842583714399085*^9, 3.8425837200071774`*^9}, {
   3.842583763516223*^9, 3.842583773099656*^9}, {3.8425838115546145`*^9, 
   3.8425838374513693`*^9}, {3.842583879906367*^9, 3.842583889263523*^9}, {
   3.842584058510779*^9, 3.8425840727055025`*^9}, 3.8425842620930233`*^9, {
   3.8425843561955433`*^9, 3.842584376298211*^9}, 3.8425845983201103`*^9, 
   3.8425847122462034`*^9, 3.84258491490175*^9, 3.842584952313361*^9, 
   3.8425850866940217`*^9, {3.842585182570103*^9, 3.8425851969940715`*^9}, 
   3.842591337573143*^9, 3.8425914656330624`*^9, 3.8425916100030255`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"71edacc7-3151-4a32-ab57-c80d3180db0c"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.8425836722930884`*^9},
 CellLabel->"In[39]:=",ExpressionUUID->"74a17246-a624-42e3-af83-3900bb349d0c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"reac", "=", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"ecs", "[", 
      RowBox[{"[", "cono", "]"}], "]"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"eq", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "6", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"eq", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "=", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"W", "[", "1", "]"}], "+", 
        RowBox[{"W", "[", "13", "]"}]}], "\[Equal]", "P"}], "/.", "reac"}], 
     "]"}]}], " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"ecs", "[", 
     RowBox[{"[", "4", "]"}], "]"}], "/.", "axil"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "=", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "8", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "3", "]"}], "]"}], "=", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "6", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "4", "]"}], "]"}], "=", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "9", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "5", "]"}], "]"}], "=", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "12", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eq", "[", 
   RowBox[{"[", "6", "]"}], "]"}], "=", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "15", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.842581433030716*^9, 3.842581457540603*^9}, {
   3.84258266497657*^9, 3.8425826812066526`*^9}, {3.8425827819748554`*^9, 
   3.8425828562533464`*^9}, {3.842582919135109*^9, 3.8425829340391555`*^9}, {
   3.8425834486157646`*^9, 3.8425834675063305`*^9}, {3.842583725646486*^9, 
   3.8425837393201094`*^9}, 3.842583808977823*^9, {3.84259143163805*^9, 
   3.842591457813099*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"ae88a002-63cc-403c-93c9-0652965638cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1.`", " ", "P"}], "+", 
   RowBox[{"1.2000000000000002`", " ", 
    RowBox[{"Mz", "[", 
     RowBox[{"1", ",", "1"}], "]"}]}], "+", 
   RowBox[{"1.2000000000000002`", " ", 
    RowBox[{"Mz", "[", 
     RowBox[{"1", ",", "2"}], "]"}]}], "+", 
   RowBox[{"1.2000000000000002`", " ", 
    RowBox[{"Mz", "[", 
     RowBox[{"3", ",", "4"}], "]"}]}], "+", 
   RowBox[{"1.2000000000000002`", " ", 
    RowBox[{"Mz", "[", 
     RowBox[{"3", ",", "5"}], "]"}]}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.842591611124426*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"6deefbf1-5a67-42ee-aa77-0253960b37d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.`", "\[VeryThinSpace]", "-", "P", "+", 
   RowBox[{"0.2`", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Mz", "[", 
        RowBox[{"2", ",", "2"}], "]"}]}], "-", 
      RowBox[{"Mz", "[", 
       RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "-", 
   RowBox[{"0.2`", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Mz", "[", 
        RowBox[{"4", ",", "3"}], "]"}]}], "-", 
      RowBox[{"Mz", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}], "\[Equal]", 
  "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.8425916111335397`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"c41fa4a1-cd56-46f7-b39f-7f307647a348"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.`", "\[VeryThinSpace]", "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"2", ",", "2"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.842591611143439*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"19a8afbb-e237-4fdb-a62a-834dc14f3906"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.`", "\[VeryThinSpace]", "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"2", ",", "3"}], "]"}], "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"4", ",", "3"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.8425916111533437`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"de2661a1-42ac-4c05-82b7-c8965022d0f8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.`", "\[VeryThinSpace]", "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.842591611158351*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"9ee315da-2d10-4a5f-88f1-8e3ed160b7fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.`", "\[VeryThinSpace]", "+", 
   RowBox[{"Mz", "[", 
    RowBox[{"3", ",", "5"}], "]"}]}], "\[Equal]", "0"}]], "Output",
 CellChangeTimes->{{3.8425814523230352`*^9, 3.842581458227903*^9}, 
   3.8425822031210947`*^9, 3.8425823299716067`*^9, {3.8425824198135834`*^9, 
   3.8425824300313087`*^9}, 3.8425824912140007`*^9, {3.8425825364472632`*^9, 
   3.8425825512702713`*^9}, 3.842582685565005*^9, 3.8425828135719194`*^9, 
   3.842582856472039*^9, 3.8425829346014957`*^9, 3.842583291938035*^9, 
   3.842583379674244*^9, {3.8425834718802743`*^9, 3.842583476412016*^9}, {
   3.842583536934828*^9, 3.8425835548259387`*^9}, {3.8425837265212727`*^9, 
   3.842583773130896*^9}, {3.8425838091652637`*^9, 3.8425838385761447`*^9}, {
   3.842583879953232*^9, 3.842583900809061*^9}, {3.8425840585743074`*^9, 
   3.842584072753559*^9}, 3.842584262139888*^9, {3.8425843562424073`*^9, 
   3.8425843763450775`*^9}, 3.8425845983825836`*^9, 3.8425847122930903`*^9, 
   3.8425849149491577`*^9, 3.842584952360223*^9, 3.842585087803156*^9, {
   3.8425851826013803`*^9, 3.84258519703047*^9}, 3.8425913376230736`*^9, {
   3.8425914581829815`*^9, 3.842591465672989*^9}, 3.842591611163437*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"bee18bc2-71f3-4d95-be47-16df8a829b79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"ecs", "[", 
   RowBox[{"[", "incog", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8425835181987867`*^9, 3.842583547423787*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"b2fffffa-fd6d-4cb8-94a4-13ba54985213"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Mz", "[", 
              RowBox[{"1", ",", "1"}], "]"}]}], "-", 
            RowBox[{"Mz", "[", 
             RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "2", "]"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "2"}], "]"}], "+", 
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "+", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "1", "]"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"1", ",", "2"}], "]"}], "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "2", "]"}]}], "-", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "4", "]"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "-", "P", "+", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Mz", "[", 
              RowBox[{"2", ",", "2"}], "]"}]}], "-", 
            RowBox[{"Mz", "[", 
             RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "-", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Mz", "[", 
              RowBox[{"4", ",", "3"}], "]"}]}], "-", 
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"2", ",", "3"}], "]"}], "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"4", ",", "3"}], "]"}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         FractionBox["P", "6"], "-", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Mz", "[", 
              RowBox[{"3", ",", "4"}], "]"}]}], "-", 
            RowBox[{"Mz", "[", 
             RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}], "-", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "4", "]"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "-", 
         RowBox[{"0.2`", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "3"}], "]"}], "+", 
            RowBox[{"Mz", "[", 
             RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}], "+", 
         RowBox[{"1.`", " ", 
          RowBox[{"Nx", "[", "3", "]"}]}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"3", ",", "4"}], "]"}], "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"4", ",", "4"}], "]"}]}], "\[Equal]", "0"}]},
      {
       RowBox[{
        RowBox[{"0.`", "\[VeryThinSpace]", "+", 
         RowBox[{"Mz", "[", 
          RowBox[{"3", ",", "5"}], "]"}]}], "\[Equal]", "0"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.842583528243308*^9, 3.8425835548728*^9}, {
   3.842583763609984*^9, 3.842583773194827*^9}, {3.842583811665537*^9, 
   3.842583839513386*^9}, 3.8425839008715467`*^9, {3.842584058625149*^9, 
   3.8425840728197594`*^9}, 3.8425842621966763`*^9, {3.842584356316936*^9, 
   3.8425843764231853`*^9}, 3.8425845984606905`*^9, 3.842584712355587*^9, 
   3.8425849150116425`*^9, 3.842584952422711*^9, 3.8425850887403913`*^9, {
   3.84258518266788*^9, 3.8425851970968304`*^9}, 3.8425913384630513`*^9, 
   3.8425914827732763`*^9, 3.8425916112781715`*^9},
 CellLabel->
  "Out[48]//MatrixForm=",ExpressionUUID->"b8ef4c0f-9123-4f3b-abb2-\
d67edfd2b951"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.842579633641781*^9},
 CellLabel->"In[49]:=",ExpressionUUID->"1ef0eb2a-295c-4a81-891c-d32e392ec544"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PFV1", "[", 
   RowBox[{"Ma_", ",", "Mb_", ",", "ma_", ",", "mb_", ",", "L_", ",", "EI_"}],
    "]"}], ":=", 
  RowBox[{
   RowBox[{"L", "/", 
    RowBox[{"(", 
     RowBox[{"6", " ", "EI"}], ")"}]}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ma", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "Ma"}], "+", "Mb"}], ")"}]}], "+", 
     RowBox[{"mb", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "Mb"}], "+", "Ma"}], ")"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[50]:=",ExpressionUUID->"2c5f2cb3-ba4f-407a-b27e-feb2650d08fa"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Mij", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rM", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vM", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v\[Theta]", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ed", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"b", "=", "1"}], ",", 
    RowBox[{"b", "<=", "nb"}], ",", 
    RowBox[{"b", "++"}], ",", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"i", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"barras", "[", 
          RowBox[{"[", "b", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"j", "=", 
       RowBox[{
        RowBox[{
         RowBox[{"barras", "[", 
          RowBox[{"[", "b", "]"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"L", "=", 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"xy", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"xy", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"xy", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"xy", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], 
         ")"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"vEi", "=", 
       RowBox[{
        RowBox[{"material", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"barras", "[", 
             RowBox[{"[", "b", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ii", "=", 
       RowBox[{
        RowBox[{"perfil", "[", 
         RowBox[{"[", 
          RowBox[{
           RowBox[{
            RowBox[{"barras", "[", 
             RowBox[{"[", "b", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"Mij", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"Mij", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "Mp"}], "\[LessEqual]", 
            RowBox[{"Mz", "[", 
             RowBox[{"b", ",", "i"}], "]"}], "\[LessEqual]", "Mp"}], ",", 
           RowBox[{
            RowBox[{"-", "Mp"}], "\[LessEqual]", 
            RowBox[{"Mz", "[", 
             RowBox[{"b", ",", "j"}], "]"}], "\[LessEqual]", "Mp"}]}], 
          "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"rM", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"rM", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Mz", "[", 
            RowBox[{"b", ",", "i"}], "]"}], ",", 
           RowBox[{"Mz", "[", 
            RowBox[{"b", ",", "j"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"vM", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"vM", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"m", "[", 
            RowBox[{"b", ",", "i"}], "]"}], ",", 
           RowBox[{"m", "[", 
            RowBox[{"b", ",", "j"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"v\[Theta]", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"v\[Theta]", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Theta]", "[", 
            RowBox[{"b", ",", "i"}], "]"}], ",", 
           RowBox[{"\[Theta]", "[", 
            RowBox[{"b", ",", "j"}], "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Ma", "=", 
       RowBox[{"Mz", "[", 
        RowBox[{"b", ",", "i"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Mb", "=", 
       RowBox[{"Mz", "[", 
        RowBox[{"b", ",", "j"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Ed", "+=", 
       RowBox[{"PFV1", "[", 
        RowBox[{
         RowBox[{"-", "Ma"}], ",", "Mb", ",", 
         RowBox[{"-", "Ma"}], ",", "Mb", ",", "L", ",", 
         RowBox[{"vEi", " ", "Ii"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
     "}"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", "rM", "\[IndentingNewLine]", "v\[Theta]"}], \
"Input",
 CellChangeTimes->{{3.84236321115728*^9, 3.8423632877353954`*^9}, {
  3.842363485094949*^9, 3.8423636034072466`*^9}, {3.842363647938452*^9, 
  3.8423636655323615`*^9}, {3.842363903141679*^9, 3.8423639036104097`*^9}, {
  3.842424304759272*^9, 3.842424322072276*^9}, {3.8424243629628954`*^9, 
  3.84242442675935*^9}, {3.842444742931568*^9, 3.8424447524626184`*^9}, {
  3.8424448787907763`*^9, 3.842444915040555*^9}, {3.8424453916501675`*^9, 
  3.8424453940092287`*^9}, {3.8424456482905426`*^9, 3.8424456591656284`*^9}, {
  3.842449487071756*^9, 3.8424495076972566`*^9}, {3.8425726806247215`*^9, 
  3.8425727136249914`*^9}, {3.8425727634531083`*^9, 3.8425727711246862`*^9}, {
  3.8425842579493427`*^9, 3.84258425999571*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"24c6ce91-8239-4e7c-9e60-53552b680125"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mz", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"3", ",", "5"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"3", ",", "4"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"4", ",", "4"}], "]"}], ",", 
   RowBox[{"Mz", "[", 
    RowBox[{"4", ",", "3"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8423632556106195`*^9, 3.842363287891724*^9, 3.8423636664543047`*^9, {
   3.84236387768863*^9, 3.842363903766863*^9}, 3.8423646531260166`*^9, 
   3.842367208016958*^9, 3.8423673349858017`*^9, 3.842368225188512*^9, 
   3.8424068350079803`*^9, 3.8424071498393126`*^9, 3.842410536768959*^9, {
   3.842410592959158*^9, 3.8424106147960253`*^9}, 3.842410771204235*^9, 
   3.8424112690877647`*^9, 3.8424117092039566`*^9, {3.8424242392127314`*^9, 
   3.8424242499311714`*^9}, 3.8424243226660576`*^9, 3.8424243680093365`*^9, {
   3.842424407853524*^9, 3.8424244275097218`*^9}, {3.8424244909624577`*^9, 
   3.8424245130097127`*^9}, 3.8424444337126846`*^9, 3.8424447533843794`*^9, 
   3.842444845696967*^9, {3.84244487949411*^9, 3.842444881103411*^9}, 
   3.8424449167909307`*^9, 3.8424450752749944`*^9, 3.8424451661187277`*^9, {
   3.842445204603196*^9, 3.842445222462495*^9}, 3.8424452543999677`*^9, 
   3.842445352509293*^9, {3.8424453947905874`*^9, 3.8424454052440586`*^9}, 
   3.842445464431173*^9, {3.8424456553062043`*^9, 3.8424456599001036`*^9}, 
   3.8424457760406837`*^9, 3.842446745306183*^9, 3.8424473291655293`*^9, 
   3.84244765021246*^9, 3.842447930197229*^9, 3.842447974759489*^9, 
   3.8424481842437105`*^9, 3.842448289556384*^9, {3.842448382697051*^9, 
   3.8424484015251503`*^9}, {3.84244867860347*^9, 3.8424486957907963`*^9}, 
   3.842448944493998*^9, 3.842449095947114*^9, 3.842449230899973*^9, {
   3.842449316353033*^9, 3.8424493388375697`*^9}, 3.8424494263221655`*^9, 
   3.842449509400214*^9, 3.8425722405154004`*^9, {3.8425723200469465`*^9, 
   3.842572348734129*^9}, 3.8425725080469913`*^9, 3.842572620812369*^9, {
   3.842572702609519*^9, 3.8425727720001373`*^9}, {3.842572991578074*^9, 
   3.8425730185934763`*^9}, 3.842578454464532*^9, {3.842578733927816*^9, 
   3.842578750514192*^9}, 3.8425788008001814`*^9, 3.8425791385395217`*^9, 
   3.842579190746566*^9, 3.8425796397184877`*^9, 3.842579854553569*^9, 
   3.8425799192902193`*^9, 3.8425804317038393`*^9, 3.842580749405137*^9, 
   3.8425817106315513`*^9, 3.842582330283109*^9, 3.84258249152993*^9, 
   3.8425827248006735`*^9, 3.8425828299007854`*^9, 3.84258286284552*^9, 
   3.84258294072506*^9, 3.842583293153929*^9, 3.8425833797457995`*^9, 
   3.842583476521364*^9, 3.8425835370442*^9, {3.842583758190712*^9, 
   3.842583773272935*^9}, {3.8425838117164917`*^9, 3.8425838395914927`*^9}, 
   3.8425839009340453`*^9, {3.8425840586876664`*^9, 3.842584072873112*^9}, 
   3.8425842622591734`*^9, {3.8425843563794217`*^9, 3.842584376485671*^9}, 
   3.8425845985231743`*^9, 3.84258471240244*^9, 3.8425849150741167`*^9, 
   3.842584952485196*^9, 3.8425850888028784`*^9, {3.8425851827303677`*^9, 
   3.8425851971593*^9}, 3.8425913385630636`*^9, 3.842591482874814*^9, 
   3.8425916121181993`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"cddd559f-9e31-4d1a-9598-61843ecccfb0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Theta]", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"1", ",", "2"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"2", ",", "2"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"2", ",", "3"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"3", ",", "5"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"3", ",", "4"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"4", ",", "4"}], "]"}], ",", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"4", ",", "3"}], "]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8423632556106195`*^9, 3.842363287891724*^9, 3.8423636664543047`*^9, {
   3.84236387768863*^9, 3.842363903766863*^9}, 3.8423646531260166`*^9, 
   3.842367208016958*^9, 3.8423673349858017`*^9, 3.842368225188512*^9, 
   3.8424068350079803`*^9, 3.8424071498393126`*^9, 3.842410536768959*^9, {
   3.842410592959158*^9, 3.8424106147960253`*^9}, 3.842410771204235*^9, 
   3.8424112690877647`*^9, 3.8424117092039566`*^9, {3.8424242392127314`*^9, 
   3.8424242499311714`*^9}, 3.8424243226660576`*^9, 3.8424243680093365`*^9, {
   3.842424407853524*^9, 3.8424244275097218`*^9}, {3.8424244909624577`*^9, 
   3.8424245130097127`*^9}, 3.8424444337126846`*^9, 3.8424447533843794`*^9, 
   3.842444845696967*^9, {3.84244487949411*^9, 3.842444881103411*^9}, 
   3.8424449167909307`*^9, 3.8424450752749944`*^9, 3.8424451661187277`*^9, {
   3.842445204603196*^9, 3.842445222462495*^9}, 3.8424452543999677`*^9, 
   3.842445352509293*^9, {3.8424453947905874`*^9, 3.8424454052440586`*^9}, 
   3.842445464431173*^9, {3.8424456553062043`*^9, 3.8424456599001036`*^9}, 
   3.8424457760406837`*^9, 3.842446745306183*^9, 3.8424473291655293`*^9, 
   3.84244765021246*^9, 3.842447930197229*^9, 3.842447974759489*^9, 
   3.8424481842437105`*^9, 3.842448289556384*^9, {3.842448382697051*^9, 
   3.8424484015251503`*^9}, {3.84244867860347*^9, 3.8424486957907963`*^9}, 
   3.842448944493998*^9, 3.842449095947114*^9, 3.842449230899973*^9, {
   3.842449316353033*^9, 3.8424493388375697`*^9}, 3.8424494263221655`*^9, 
   3.842449509400214*^9, 3.8425722405154004`*^9, {3.8425723200469465`*^9, 
   3.842572348734129*^9}, 3.8425725080469913`*^9, 3.842572620812369*^9, {
   3.842572702609519*^9, 3.8425727720001373`*^9}, {3.842572991578074*^9, 
   3.8425730185934763`*^9}, 3.842578454464532*^9, {3.842578733927816*^9, 
   3.842578750514192*^9}, 3.8425788008001814`*^9, 3.8425791385395217`*^9, 
   3.842579190746566*^9, 3.8425796397184877`*^9, 3.842579854553569*^9, 
   3.8425799192902193`*^9, 3.8425804317038393`*^9, 3.842580749405137*^9, 
   3.8425817106315513`*^9, 3.842582330283109*^9, 3.84258249152993*^9, 
   3.8425827248006735`*^9, 3.8425828299007854`*^9, 3.84258286284552*^9, 
   3.84258294072506*^9, 3.842583293153929*^9, 3.8425833797457995`*^9, 
   3.842583476521364*^9, 3.8425835370442*^9, {3.842583758190712*^9, 
   3.842583773272935*^9}, {3.8425838117164917`*^9, 3.8425838395914927`*^9}, 
   3.8425839009340453`*^9, {3.8425840586876664`*^9, 3.842584072873112*^9}, 
   3.8425842622591734`*^9, {3.8425843563794217`*^9, 3.842584376485671*^9}, 
   3.8425845985231743`*^9, 3.84258471240244*^9, 3.8425849150741167`*^9, 
   3.842584952485196*^9, 3.8425850888028784`*^9, {3.8425851827303677`*^9, 
   3.8425851971593*^9}, 3.8425913385630636`*^9, 3.842591482874814*^9, 
   3.842591612125244*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"caca3c6a-7fb1-471c-8b9c-8a05c07bd469"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8424456640093307`*^9, 3.842445666759309*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"5ef367c0-0bb3-4b0a-8fa3-9564813ae358"],

Cell[CellGroupData[{

Cell[BoxData["Ed"], "Input",
 CellChangeTimes->{{3.842363668829158*^9, 3.842363669407246*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"7942554b-91c6-4f01-a8db-8346ed5895f5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4.746715273031063`*^-8", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Mz", "[", 
        RowBox[{"1", ",", "1"}], "]"}]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"1", ",", "1"}], "]"}]}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"1", ",", "2"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"1", ",", "2"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Mz", "[", 
          RowBox[{"1", ",", "1"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"1", ",", "2"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{"4.746715273031063`*^-8", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Mz", "[", 
        RowBox[{"2", ",", "2"}], "]"}]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}], "+", 
        RowBox[{"Mz", "[", 
         RowBox[{"2", ",", "3"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"2", ",", "3"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Mz", "[", 
          RowBox[{"2", ",", "2"}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"2", ",", "3"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{"4.746715273031063`*^-8", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "4"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"3", ",", "4"}], "]"}]}], "-", 
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "5"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Mz", "[", 
         RowBox[{"3", ",", "4"}], "]"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"3", ",", "5"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "5"}], "]"}]}]}], ")"}]}], "+", 
  RowBox[{"4.746715273031063`*^-8", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"4", ",", "3"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"4", ",", "3"}], "]"}]}], "-", 
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "4"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Mz", "[", 
         RowBox[{"4", ",", "3"}], "]"}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"Mz", "[", 
          RowBox[{"4", ",", "4"}], "]"}]}]}], ")"}], " ", 
      RowBox[{"Mz", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.842363669547837*^9, {3.842363883204364*^9, 3.842363907016877*^9}, 
   3.842367208048046*^9, 3.8423673350324974`*^9, 3.8423682252353477`*^9, 
   3.84240683507047*^9, 3.842407149886176*^9, 3.8424105368158245`*^9, {
   3.8424105930070615`*^9, 3.8424106148741302`*^9}, 3.8424107712511263`*^9, 
   3.8424112691658874`*^9, 3.842411709253639*^9, {3.842424239259486*^9, 
   3.842424249994046*^9}, 3.842424326603125*^9, {3.8424244910093203`*^9, 
   3.8424245130718355`*^9}, 3.8424444337594795`*^9, 3.8424447563222427`*^9, 
   3.8424448457438755`*^9, 3.842444881150052*^9, 3.8424449168219166`*^9, 
   3.842445075321817*^9, 3.842445166165862*^9, {3.842445204634425*^9, 
   3.8424452225096397`*^9}, 3.8424452544471626`*^9, 3.8424453525408196`*^9, 
   3.8424454053062277`*^9, 3.8424454645097866`*^9, 3.842445776134426*^9, 
   3.842446745399972*^9, 3.84244732927527*^9, 3.8424476503218603`*^9, 
   3.8424479302909684`*^9, 3.8424479748686934`*^9, 3.842448184353403*^9, 
   3.842448289665821*^9, {3.842448382806181*^9, 3.8424484016343184`*^9}, {
   3.8424486786816583`*^9, 3.842448695869013*^9}, 3.8424489446030617`*^9, 
   3.8424490960718794`*^9, 3.842449230993976*^9, {3.84244931647841*^9, 
   3.8424493389780717`*^9}, 3.842449426525258*^9, 3.8424495094780865`*^9, 
   3.842572240609578*^9, {3.8425723201406446`*^9, 3.8425723488125772`*^9}, 
   3.842572508140395*^9, 3.8425726209219112`*^9, {3.842572783718575*^9, 
   3.8425727859689403`*^9}, {3.8425729916563387`*^9, 3.842573018655961*^9}, 
   3.842578454511397*^9, {3.842578736599058*^9, 3.8425787505767107`*^9}, 
   3.842578800893944*^9, 3.842579138617626*^9, 3.8425791908247013`*^9, 
   3.8425796397965636`*^9, 3.842579854631682*^9, 3.842579919368326*^9, 
   3.842580431772219*^9, 3.842580749498836*^9, 3.842582330345595*^9, 
   3.8425824915839915`*^9, 3.8425827248475685`*^9, 3.8425828299476633`*^9, 
   3.842582862892415*^9, 3.8425829407719245`*^9, 3.8425832940287247`*^9, 
   3.8425833798082867`*^9, 3.8425834765682287`*^9, 3.842583537091078*^9, {
   3.842583758251726*^9, 3.842583773335421*^9}, {3.842583811763389*^9, 
   3.842583839692086*^9}, 3.842583900996542*^9, {3.8425840587657423`*^9, 
   3.842584072936861*^9}, 3.842584262328684*^9, {3.8425843564419394`*^9, 
   3.8425843765325336`*^9}, 3.8425845985939927`*^9, 3.8425847124649363`*^9, 
   3.842584915136613*^9, 3.8425849525320597`*^9, 3.842585088865363*^9, {
   3.8425851827772617`*^9, 3.84258519720618*^9}, 3.842591338617881*^9, 
   3.842591482942934*^9, 3.842591612178251*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"812b04b9-03b8-481a-bc9f-94e36c04af64"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "P", "}"}], ",", "eq", ",", "Mij"}], "]"}], "//.", 
      "datos"}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "P", "}"}], ",", "rM"}], "]"}]}], "]"}], "//", 
   "Quiet"}]}]], "Input",
 CellChangeTimes->{{3.842231445483567*^9, 3.8422314994520736`*^9}, {
   3.8422322323113575`*^9, 3.8422322573115005`*^9}, {3.842232365858093*^9, 
   3.842232370061754*^9}, {3.8422327626087203`*^9, 3.842232814296322*^9}, {
   3.842232867702597*^9, 3.842232878327179*^9}, {3.842232944561426*^9, 
   3.8422329497805815`*^9}, 3.8422341752958145`*^9, {3.8422342252646284`*^9, 
   3.8422342873740897`*^9}, 3.84223471251443*^9, {3.842234778295779*^9, 
   3.8422347890145006`*^9}, {3.8422353064055166`*^9, 3.842235307170808*^9}, {
   3.8422361236241317`*^9, 3.842236178530431*^9}, {3.8422362098427224`*^9, 
   3.8422363114677286`*^9}, {3.8422475702496333`*^9, 
   3.8422476193591347`*^9}, {3.8422476729997187`*^9, 
   3.8422476759215508`*^9}, {3.8422521702965593`*^9, 
   3.8422524876871877`*^9}, {3.8422525218278866`*^9, 3.842252528765347*^9}, {
   3.8422525771094213`*^9, 3.8422527320933723`*^9}, {3.8422527743592386`*^9, 
   3.8422527822187653`*^9}, {3.84225348467152*^9, 3.842253572655954*^9}, {
   3.842267016702719*^9, 3.842267016828182*^9}, {3.8422670858747025`*^9, 
   3.842267174218707*^9}, {3.8422672140778074`*^9, 3.8422672141720085`*^9}, {
   3.8422672900781536`*^9, 3.84226729857825*^9}, {3.842267380171914*^9, 
   3.8422674078279495`*^9}, {3.842268290327817*^9, 3.842268300937587*^9}, {
   3.8422698532340345`*^9, 3.842269898687564*^9}, 3.8422700994059305`*^9, {
   3.842270397796588*^9, 3.842270412140254*^9}, {3.8422706682184925`*^9, 
   3.842270678265336*^9}, {3.842271003889946*^9, 3.8422710040154023`*^9}, {
   3.842271087499608*^9, 3.8422710941246347`*^9}, {3.8422785941402607`*^9, 
   3.8422786173902297`*^9}, {3.842278713749753*^9, 3.842278804530997*^9}, {
   3.8422788928589897`*^9, 3.8422788929532843`*^9}, {3.842279136374934*^9, 
   3.842279141030945*^9}, {3.842279202562191*^9, 3.8422792382652693`*^9}, {
   3.8422795588590302`*^9, 3.8422795736092854`*^9}, {3.8423206897212105`*^9, 
   3.842320701668537*^9}, {3.8423207327094946`*^9, 3.8423207660793*^9}, {
   3.8423210451659217`*^9, 3.84232104524409*^9}, {3.842321453654417*^9, 
   3.84232147299957*^9}, {3.842325645298938*^9, 3.8423256478265986`*^9}, {
   3.8423610603294306`*^9, 3.842361060438669*^9}, {3.8423611013604774`*^9, 
   3.842361103891672*^9}, {3.842361662860386*^9, 3.842361665610374*^9}, {
   3.8423622823760443`*^9, 3.8423622824699287`*^9}, {3.842362345313552*^9, 
   3.842362365016553*^9}, {3.842362742313381*^9, 3.8423627728135595`*^9}, {
   3.8423630271728573`*^9, 3.842363048313487*^9}, {3.8423631497353373`*^9, 
   3.842363150547979*^9}, {3.8423632970483866`*^9, 3.842363297329174*^9}, {
   3.842363340516633*^9, 3.842363344923011*^9}, {3.842363685360284*^9, 
   3.8423637549228506`*^9}, {3.8423638116104064`*^9, 3.842363822501445*^9}, {
   3.8423639528759212`*^9, 3.842363970094751*^9}, {3.842364000594742*^9, 
   3.8423640237510567`*^9}, {3.84236419818854*^9, 3.842364198282261*^9}, {
   3.8423642900164723`*^9, 3.8423643038763065`*^9}, {3.842364433219751*^9, 
   3.8423644359073153`*^9}, 3.8423645381259804`*^9, 3.8423645880322447`*^9, {
   3.8423646340321407`*^9, 3.8423646344386415`*^9}, {3.8423647003133125`*^9, 
   3.8423647102513666`*^9}, {3.8423648423135223`*^9, 
   3.8423648620169477`*^9}, {3.8423651610791373`*^9, 3.842365171392125*^9}, {
   3.842367023438508*^9, 3.842367024672777*^9}, {3.8423672717980785`*^9, 
   3.842367299548308*^9}, {3.842447044399911*^9, 3.84244704455626*^9}, 
   3.842582736821721*^9, 3.842582949827545*^9, {3.842583376985436*^9, 
   3.8425834049781246`*^9}, {3.8425837684948697`*^9, 3.8425837696508512`*^9}, 
   3.842583817803074*^9, {3.8425840532966747`*^9, 3.842584067630554*^9}, {
   3.842584265980809*^9, 3.842584270328491*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"f2296a22-1539-4b87-9893-cb5272d3e72d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"138160.00000000003`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"P", "\[Rule]", "138160.00000000003`"}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
      RowBox[{"-", "115133.33333333333`"}]}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", "172700.`"}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
      RowBox[{"-", "172700.`"}]}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"2", ",", "3"}], "]"}], "\[Rule]", 
      RowBox[{"-", "172700.00000000006`"}]}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "5"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"3", ",", "4"}], "]"}], "\[Rule]", 
      RowBox[{"-", "172700.`"}]}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"4", ",", "4"}], "]"}], "\[Rule]", "172700.`"}], ",", 
     RowBox[{
      RowBox[{"Mz", "[", 
       RowBox[{"4", ",", "3"}], "]"}], "\[Rule]", "172700.00000000006`"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.842364715892069*^9, {3.8423648435013027`*^9, 3.842364867750772*^9}, 
   3.8423650672201614`*^9, {3.842365151016937*^9, 3.8423651980795827`*^9}, 
   3.842365257001465*^9, 3.8423667885479164`*^9, 3.8423670259854636`*^9, 
   3.842367211204202*^9, 3.842367277360586*^9, {3.842367311563492*^9, 
   3.842367338157422*^9}, 3.8423682270009727`*^9, 3.842406836901626*^9, 
   3.842407150901558*^9, 3.842410539737012*^9, {3.8424105958813577`*^9, 
   3.84241061825163*^9}, 3.8424107741566696`*^9, 3.8424112721722693`*^9, 
   3.842411712284207*^9, {3.8424242407280636`*^9, 3.8424242519309*^9}, {
   3.8424244863845787`*^9, 3.842424514290747*^9}, 3.842444435103541*^9, 
   3.842444759556546*^9, 3.842444847056255*^9, 3.842444882540735*^9, 
   3.842444918087432*^9, 3.8424450765405645`*^9, 3.8424451673861837`*^9, {
   3.842445205853298*^9, 3.8424452236966743`*^9}, 3.8424452556500115`*^9, 
   3.842445353759307*^9, 3.8424454065874805`*^9, 3.842445465790516*^9, 
   3.842445777431481*^9, 3.84244674682189*^9, {3.8424470418377934`*^9, 
   3.8424470467592707`*^9}, 3.842447330477887*^9, 3.84244765154036*^9, 
   3.842447931540379*^9, 3.8424479761184683`*^9, 3.8424481856030326`*^9, 
   3.842448290868601*^9, {3.842448384118493*^9, 3.8424484029001274`*^9}, {
   3.8424486799468174`*^9, 3.84244869708781*^9}, 3.842448945915515*^9, 
   3.842449097400342*^9, 3.842449232243678*^9, {3.84244931846282*^9, 
   3.8424493409621096`*^9}, 3.842449428399936*^9, 3.8424495107593184`*^9, 
   3.8425722459372663`*^9, {3.842572321421627*^9, 3.8425723500934715`*^9}, 
   3.8425725093590827`*^9, 3.8425726221871986`*^9, 3.8425727965935726`*^9, {
   3.8425729929840956`*^9, 3.8425730198902407`*^9}, 3.842578456414569*^9, {
   3.8425787394421434`*^9, 3.8425787535447645`*^9}, 3.8425788033991003`*^9, 
   3.842579141802179*^9, 3.842579193393854*^9, 3.842579641469117*^9, 
   3.8425798563356175`*^9, 3.8425799220864706`*^9, 3.842580433399541*^9, 
   3.8425807509672403`*^9, 3.8425823304080987`*^9, 3.8425824916659155`*^9, {
   3.842582724894422*^9, 3.8425827384943275`*^9}, 3.842582830244425*^9, 
   3.842582863033007*^9, {3.8425829408921175`*^9, 3.842582950686711*^9}, 
   3.842583294278695*^9, {3.842583377313451*^9, 3.8425834056810436`*^9}, 
   3.8425834766150923`*^9, 3.8425835371379085`*^9, {3.8425837582986245`*^9, 
   3.842583773382287*^9}, {3.842583812013297*^9, 3.8425838399107857`*^9}, 
   3.842583901027758*^9, {3.842584044689331*^9, 3.842584072983694*^9}, {
   3.842584262391199*^9, 3.8425842709845533`*^9}, {3.842584356473179*^9, 
   3.8425843765794024`*^9}, 3.842584598640824*^9, 3.842584712511801*^9, 
   3.842584915167856*^9, 3.8425849525874314`*^9, 3.842585089130927*^9, {
   3.8425851828240952`*^9, 3.8425851972530136`*^9}, 3.8425913388631163`*^9, 
   3.842591482983059*^9, 3.842591612438201*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"f6ae244b-d1f6-4331-8e91-4f07c83f47a9"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.8424469964155903`*^9, 3.8424470473064137`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"ed1965d8-a8ad-4199-9b19-fd3d8aa9eb69"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "comprobar", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Pc", "=", 
   RowBox[{
    RowBox[{"4", 
     RowBox[{"Mp", "/", "L0"}]}], "//.", "datos"}]}]}]], "Input",
 CellChangeTimes->{{3.8424470013222647`*^9, 3.8424470058843703`*^9}, {
   3.8425808097379456`*^9, 3.8425808113781867`*^9}, {3.8425829633569355`*^9, 
   3.8425829764163866`*^9}, 3.842591488363386*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"7c70b767-8c9b-4f20-879c-7bd0727a2e04"],

Cell[BoxData["138160.`"], "Output",
 CellChangeTimes->{
  3.842582977197438*^9, 3.8425832943724194`*^9, 3.8425833799644966`*^9, 
   3.842583476661989*^9, 3.842583537184803*^9, {3.8425837583454914`*^9, 
   3.842583773429119*^9}, {3.842583812060161*^9, 3.842583839957649*^9}, 
   3.8425839010746527`*^9, {3.842584058984461*^9, 3.842584073014942*^9}, 
   3.8425842624224443`*^9, {3.842584356520045*^9, 3.8425843766262608`*^9}, 
   3.842584598703311*^9, 3.842584712543039*^9, 3.8425849152147026`*^9, 
   3.842584952618673*^9, 3.8425850891777906`*^9, {3.8425851828690343`*^9, 
   3.842585197299877*^9}, 3.842591338903305*^9, {3.842591483013154*^9, 
   3.842591488523365*^9}, 3.8425916124828854`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"5b1bf943-6b2a-4b7c-b746-5afc7eda8a38"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.8423262952252483`*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"cef719fa-f11d-4fe1-a4e7-592012787a23"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.842366148485857*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"18acbb10-fe28-49c2-956d-797c010a0202"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"calcular", " ", "ecs", " ", "compatibilidad"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.842248172187147*^9, 3.8422481887965956`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"bc177c88-4747-44cb-8140-9e733d4f12a4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mEQ", "=", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"CoefficientArrays", "[", 
      RowBox[{"eq", ",", "rM"}], "]"}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "mEQ", "]"}]}], "Input",
 CellChangeTimes->{{3.8422543555777884`*^9, 3.842254466031295*^9}, {
   3.8422547370310297`*^9, 3.842254737312331*^9}, {3.8422673087653046`*^9, 
   3.8422673093592443`*^9}, {3.842267347952676*^9, 3.842267360421589*^9}, 
   3.8424087923071957`*^9, {3.8424107495124645`*^9, 3.8424107695921483`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"a1e86622-e126-4889-828b-21f41dc743d1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.2000000000000002`", "1.2000000000000002`", "0", "0", 
      "1.2000000000000002`", "1.2000000000000002`", "0", "0"},
     {"0", "0", 
      RowBox[{"-", "0.2`"}], 
      RowBox[{"-", "0.2`"}], "0", "0", "0.2`", "0.2`"},
     {"0", "1.`", "1.`", "0", "0", "0", "0", "0"},
     {"0", "0", "0", "1.`", "0", "0", "0", "1.`"},
     {"0", "0", "0", "0", "0", "1.`", "1.`", "0"},
     {"0", "0", "0", "0", "1.`", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8422544180313106`*^9, 3.842254466796973*^9}, {
   3.842254594781224*^9, 3.8422546095623283`*^9}, 3.8422546622345276`*^9, 
   3.8422547030778093`*^9, 3.842254737999837*^9, {3.8422548328434925`*^9, 
   3.8422548349371643`*^9}, 3.8422668141715593`*^9, 3.842266987327998*^9, 
   3.842267043437193*^9, 3.842267270062441*^9, 3.842267332405925*^9, 
   3.8422673639684086`*^9, 3.84226741240625*^9, 3.8422688330466805`*^9, 
   3.8422699323122215`*^9, 3.842270088562603*^9, 3.842270610937386*^9, 
   3.842270938609486*^9, 3.842270979421996*^9, 3.8422711042344112`*^9, {
   3.8422712286719294`*^9, 3.8422712499996653`*^9}, 3.842319661655149*^9, 
   3.8423672116105537`*^9, {3.8423673695165615`*^9, 3.842367374391958*^9}, 
   3.8423675601572447`*^9, 3.8423678713917637`*^9, 3.842406837210967*^9, 
   3.8424084329200635`*^9, 3.8424085308808613`*^9, 3.8424086446920757`*^9, 
   3.842408792838314*^9, 3.8424089402222824`*^9, 3.8424097206076155`*^9, 
   3.8424098515480413`*^9, 3.842409934671952*^9, 3.8424100280245733`*^9, 
   3.8424105012848773`*^9, 3.842410540140611*^9, {3.842410596283296*^9, 
   3.842410618876465*^9}, {3.8424107560369997`*^9, 3.842410774578472*^9}, 
   3.842411335448402*^9, 3.8424114409841847`*^9, 3.8424117127186995`*^9, {
   3.8424242410718102`*^9, 3.842424252353396*^9}, 3.8424244494936843`*^9, {
   3.8424244926187215`*^9, 3.8424245145564747`*^9}, 3.8424444352437067`*^9, 
   3.8424447690094366`*^9, 3.8424448473061666`*^9, 3.842444882681211*^9, 
   3.842444918337846*^9, 3.8424450767906666`*^9, 3.8424451676346016`*^9, {
   3.8424452060565195`*^9, 3.8424452239159913`*^9}, 3.842445255915883*^9, 
   3.842445353978219*^9, 3.8424454068375344`*^9, 3.842445466040537*^9, 
   3.842445777696891*^9, 3.8424467554468045`*^9, 3.8424470624159036`*^9, 
   3.842447330696951*^9, 3.8424476517437367`*^9, 3.842447931712473*^9, 
   3.8424479762906065`*^9, 3.8424481857910557`*^9, 3.842448291103451*^9, {
   3.8424483843065743`*^9, 3.842448403103479*^9}, {3.8424486800874968`*^9, 
   3.842448697228365*^9}, 3.8424489461501274`*^9, 3.8424490975562563`*^9, 
   3.8424492324158664`*^9, {3.8424493187124777`*^9, 3.8424493412438545`*^9}, 
   3.8424494286190343`*^9, 3.8424495109780483`*^9, 3.842572246155984*^9, 
   3.8425723217032566`*^9, 3.8425725095469537`*^9, 3.842572622374787*^9, 
   3.8425728084373817`*^9, {3.8425729931872454`*^9, 3.8425730200625577`*^9}, 
   3.8425784566020055`*^9, 3.842578803649517*^9, 3.8425807686222296`*^9, 
   3.8425823304861865`*^9, 3.8425824918005376`*^9, 3.8425829976001697`*^9, 
   3.8425832944505033`*^9, 3.842583380042606*^9, 3.8425834767088203`*^9, 
   3.8425835372354035`*^9, {3.8425837638911695`*^9, 3.842583773496476*^9}, {
   3.8425838121538873`*^9, 3.842583840129484*^9}, 3.842583901137136*^9, {
   3.8425840590781717`*^9, 3.842584073104763*^9}, 3.8425842625317616`*^9, {
   3.84258435658253*^9, 3.8425843766887474`*^9}, 3.8425845987657967`*^9, 
   3.8425847126055284`*^9, 3.842584915277177*^9, 3.842584952681158*^9, 
   3.8425850892559195`*^9, {3.842585182931491*^9, 3.842585197349668*^9}, 
   3.8425913389579597`*^9, 3.842591497933307*^9, 3.8425916125430017`*^9},
 CellLabel->
  "Out[68]//MatrixForm=",ExpressionUUID->"e56bf5f9-8a11-40b2-9e3e-\
347b372b5e45"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "mEQ", "]"}]], "Input",
 CellChangeTimes->{{3.8424086504231825`*^9, 3.8424086610144424`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"baea1906-037e-4960-8e2a-d549803f3ce8"],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{
  3.8424086611706524`*^9, 3.8424089403101854`*^9, 3.842409720670101*^9, 
   3.842409851594906*^9, 3.842409934718816*^9, 3.842410028061886*^9, 
   3.84241050133177*^9, 3.842410540187478*^9, {3.8424105963301573`*^9, 
   3.8424106189233274`*^9}, {3.8424107586890745`*^9, 3.8424107746409316`*^9}, 
   3.842411338716498*^9, 3.842411441031039*^9, 3.8424117127691298`*^9, {
   3.842424241087407*^9, 3.8424242524001107`*^9}, 3.8424244495252867`*^9, {
   3.8424244926499896`*^9, 3.8424245146034336`*^9}, 3.84244443525933*^9, 
   3.842444769056291*^9, 3.8424448473373985`*^9, 3.842444882696863*^9, 
   3.8424449183846025`*^9, 3.842445076837431*^9, 3.8424451676813064`*^9, {
   3.8424452060875425`*^9, 3.8424452239624877`*^9}, 3.842445255962452*^9, 
   3.842445354025004*^9, 3.8424454068843265`*^9, 3.842445466071909*^9, 
   3.8424457777282906`*^9, 3.8424467554938726`*^9, 3.842447062447089*^9, 
   3.8424473307437053`*^9, 3.842447651790701*^9, 3.842447931743926*^9, 
   3.8424479763374705`*^9, 3.842448185837448*^9, 3.8424482911499343`*^9, {
   3.842448384353202*^9, 3.842448403149998*^9}, {3.8424486801187053`*^9, 
   3.8424486972594748`*^9}, 3.842448946197194*^9, 3.8424490976033773`*^9, 
   3.8424492324471874`*^9, {3.8424493187597804`*^9, 3.8424493412908525`*^9}, 
   3.842449428650194*^9, 3.8424495110250173`*^9, 3.842572246187484*^9, 
   3.8425723217343893`*^9, 3.8425725095937796`*^9, 3.842572622406307*^9, 
   3.8425728084685197`*^9, {3.842572993234293*^9, 3.8425730201095195`*^9}, 
   3.842578456636566*^9, 3.8425788037120247`*^9, 3.842580768653466*^9, 
   3.8425823305330505`*^9, 3.8425824918551283`*^9, 3.842582997647053*^9, 
   3.8425832944890375`*^9, 3.842583380073847*^9, 3.8425834767400627`*^9, 
   3.842583537266651*^9, {3.8425837639224143`*^9, 3.8425837735277543`*^9}, {
   3.8425838122476387`*^9, 3.8425838401763496`*^9}, 3.842583901173503*^9, {
   3.8425840591406555`*^9, 3.8425840731359835`*^9}, 3.8425842625786266`*^9, {
   3.8425843566293907`*^9, 3.842584376735613*^9}, 3.8425845988115797`*^9, 
   3.8425847126367397`*^9, 3.8425849153240595`*^9, 3.8425849527124014`*^9, 
   3.842585089302763*^9, {3.842585182962764*^9, 3.8425851973965664`*^9}, 
   3.8425913389932237`*^9, 3.8425914979733286`*^9, 3.8425916125780344`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"de1d6ba5-3d1c-4e0b-ae64-916e983bec79"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"vn0", "=", 
   RowBox[{"NullSpace", "[", "mEQ", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "vn0", "]"}]}], "Input",
 CellChangeTimes->{{3.8318261622959876`*^9, 3.831826253943326*^9}, {
   3.8318262889291263`*^9, 3.831826355741879*^9}, 3.831826399257552*^9, {
   3.8318264478668995`*^9, 3.8318264497108154`*^9}, {3.8318265160893908`*^9, 
   3.8318265368773203`*^9}, {3.831826609457713*^9, 3.8318266477615833`*^9}, {
   3.8318266783409424`*^9, 3.8318267390855846`*^9}, {3.8318267911610575`*^9, 
   3.8318269176571884`*^9}, {3.8318345646741915`*^9, 
   3.8318346055854125`*^9}, {3.8318346801015625`*^9, 3.831834690914015*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"9cf435ce-a2a9-4500-ab13-18854018a4ff"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.707104955518709`", 
      RowBox[{"-", "0.3526247779363332`"}], "0.3526247779363333`", 
      "0.0009276998230211337`", 
      RowBox[{"-", "2.328838989977559`*^-16"}], 
      RowBox[{"-", "0.3544801775823754`"}], "0.3544801775823751`", 
      RowBox[{"-", "0.0009276998230210087`"}]},
     {"0.0016068232276452354`", 
      RowBox[{"-", "0.4090506480278676`"}], "0.4090506480278675`", 
      RowBox[{"-", "0.4082472364140449`"}], 
      RowBox[{"-", "2.2997901796730586`*^-17"}], "0.4074438248002224`", 
      RowBox[{"-", "0.40744382480022256`"}], "0.4082472364140446`"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.8318261913415504`*^9, 3.8318262542694407`*^9}, {
   3.8318262970400105`*^9, 3.8318262990784206`*^9}, {3.831826337304453*^9, 
   3.8318263563666687`*^9}, {3.8318263878509903`*^9, 
   3.8318263998358135`*^9}, {3.831826449882565*^9, 3.8318264543514028`*^9}, {
   3.8318265163197513`*^9, 3.8318265370545244`*^9}, {3.8318266144138455`*^9, 
   3.8318266479141474`*^9}, {3.831826684491599*^9, 3.8318267397829857`*^9}, {
   3.8318267967140245`*^9, 3.8318268049607534`*^9}, {3.831826856022908*^9, 
   3.8318269177986584`*^9}, {3.8318345757416615`*^9, 3.831834606585848*^9}, 
   3.8318346916923676`*^9, 3.831859928566247*^9, 3.8318600058827057`*^9, 
   3.8318602303979173`*^9, {3.8318602958825617`*^9, 3.8318603236323133`*^9}, {
   3.8416365997398214`*^9, 3.841636620583556*^9}, 3.8416366843490286`*^9, 
   3.841636721708521*^9, 3.8416367615676756`*^9, 3.8416371231306114`*^9, 
   3.841637338661621*^9, 3.8416379312399693`*^9, {3.8416380823025208`*^9, 
   3.841638094396264*^9}, 3.8416384646928024`*^9, 3.8416385255366173`*^9, 
   3.8416406796459665`*^9, {3.8416407879896955`*^9, 3.841640815755453*^9}, {
   3.841641587070734*^9, 3.8416416167265406`*^9}, 3.8416426804609365`*^9, 
   3.8416428694141006`*^9, 3.841642904164479*^9, {3.841643694164304*^9, 
   3.8416437073671503`*^9}, 3.8416439298675156`*^9, {3.84166903502347*^9, 
   3.841669062304634*^9}, {3.841669341023609*^9, 3.841669357898571*^9}, 
   3.841669612898572*^9, 3.8416696805236936`*^9, {3.84166978961747*^9, 
   3.8416698031174016`*^9}, 3.8416702103828936`*^9, 3.841670296586304*^9, {
   3.8416704609141765`*^9, 3.8416704831956434`*^9}, 3.841670529601574*^9, 
   3.8416706267268753`*^9, 3.8416707281173315`*^9, {3.841670810429962*^9, 
   3.8416708363673167`*^9}, {3.84167121797681*^9, 3.8416712261796217`*^9}, 
   3.841717349203329*^9, {3.841812521938686*^9, 3.841812594110071*^9}, {
   3.8418126746251554`*^9, 3.8418126870649815`*^9}, {3.841840773708849*^9, 
   3.8418407863185425`*^9}, {3.84218185010855*^9, 3.8421818733270845`*^9}, {
   3.842182087546034*^9, 3.8421821229994965`*^9}, {3.8421822021084633`*^9, 
   3.842182217233812*^9}, 3.8421823424990416`*^9, {3.842228609499034*^9, 
   3.842228620311509*^9}, 3.842228677655329*^9, 3.842228767358549*^9, {
   3.8422479183593664`*^9, 3.84224796103098*^9}, 3.8422545128751335`*^9, {
   3.84225459482784*^9, 3.8422546095937977`*^9}, 3.842254662280986*^9, 
   3.842254708640284*^9, 3.842266814218423*^9, 3.842266987405959*^9, 
   3.8422670434997787`*^9, 3.8422674240787177`*^9, 3.8422678495156217`*^9, 
   3.8422688330935583`*^9, 3.8422699323437614`*^9, 3.8422700094061627`*^9, 
   3.8422700886091127`*^9, 3.8422706109684505`*^9, 3.842270938640621*^9, 
   3.8422709794687767`*^9, 3.842271106562216*^9, {3.8422712287185364`*^9, 
   3.8422712500464954`*^9}, 3.842319661702012*^9, 3.8423672116729994`*^9, 
   3.842367374423071*^9, 3.8423675631415997`*^9, 3.8423678714545856`*^9, 
   3.8424068373595247`*^9, 3.8424084519503946`*^9, 3.842408546793894*^9, 
   3.8424086640449743`*^9, 3.842408940372677*^9, 3.8424097207169647`*^9, 
   3.8424098516417694`*^9, 3.842409934775376*^9, 3.842410028124338*^9, 
   3.842410501378634*^9, 3.842410540234339*^9, {3.8424105963769903`*^9, 
   3.842410618985814*^9}, {3.8424107609854336`*^9, 3.8424107746877947`*^9}, 
   3.8424113412329087`*^9, 3.84241144110128*^9, 3.8424117128316483`*^9, {
   3.842424241103033*^9, 3.8424242524157357`*^9}, 3.842424449571895*^9, {
   3.8424244926968937`*^9, 3.8424245146187515`*^9}, 3.8424444352750406`*^9, 
   3.8424447690874586`*^9, 3.842444847368642*^9, 3.842444882712615*^9, 
   3.842444918400086*^9, 3.84244507688441*^9, 3.8424451677282567`*^9, {
   3.8424452061190033`*^9, 3.8424452239624877`*^9}, 3.8424452559780755`*^9, 
   3.8424453540718417`*^9, 3.8424454069311495`*^9, 3.842445466118927*^9, 
   3.842445777774974*^9, 3.84244675552507*^9, 3.8424470624937277`*^9, 
   3.842447330790976*^9, 3.842447651806428*^9, 3.8424479317906075`*^9, 
   3.8424479763844957`*^9, 3.842448185853099*^9, 3.8424482911972556`*^9, {
   3.842448384400136*^9, 3.842448403197218*^9}, {3.842448680150128*^9, 
   3.8424486972908125`*^9}, 3.842448946212491*^9, 3.8424490976343737`*^9, 
   3.84244923249375*^9, {3.842449318806165*^9, 3.842449341353075*^9}, 
   3.842449428696984*^9, 3.8424495110406733`*^9, 3.8425722462345495`*^9, 
   3.842572321781006*^9, 3.842572509609435*^9, 3.84257262245304*^9, 
   3.8425728085153913`*^9, {3.842572993281309*^9, 3.8425730201250563`*^9}, 
   3.8425784566521626`*^9, 3.8425788037662387`*^9, 3.842580768704299*^9, 
   3.842582330595536*^9, 3.842582491901991*^9, 3.8425829976626744`*^9, 
   3.8425832945358925`*^9, 3.8425833801207113`*^9, 3.842583476769187*^9, 
   3.8425835372978935`*^9, {3.842583763953655*^9, 3.8425837735746183`*^9}, {
   3.8425838122944803`*^9, 3.8425838402388315`*^9}, 3.8425839012203903`*^9, {
   3.842584059159065*^9, 3.842584073182874*^9}, 3.8425842626098685`*^9, {
   3.842584356676259*^9, 3.8425843767668533`*^9}, 3.8425845988612957`*^9, 
   3.8425847126836367`*^9, 3.8425849153553123`*^9, 3.8425849527592645`*^9, 
   3.8425850893496256`*^9, {3.8425851830096273`*^9, 3.842585197412159*^9}, 
   3.8425913390278435`*^9, 3.842591498003233*^9, 3.8425916126129656`*^9},
 CellLabel->
  "Out[71]//MatrixForm=",ExpressionUUID->"f9e03699-bc47-40e0-b59d-\
e3a1852c509b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"rM", "[", 
      RowBox[{"[", "i", "]"}], "]"}], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"rM", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "rM", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"50cdf8e5-0505-4ced-8bf2-d6b697d1e691"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", 
    RowBox[{"-", "115133.33333333333`"}]}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", "172700.`"}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", 
    RowBox[{"-", "172700.`"}]}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"2", ",", "3"}], "]"}], "\[Rule]", 
    RowBox[{"-", "172700.00000000006`"}]}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"3", ",", "5"}], "]"}], "\[Rule]", "0.`"}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"3", ",", "4"}], "]"}], "\[Rule]", 
    RowBox[{"-", "172700.`"}]}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"4", ",", "4"}], "]"}], "\[Rule]", "172700.`"}], ",", 
   RowBox[{
    RowBox[{"Mz", "[", 
     RowBox[{"4", ",", "3"}], "]"}], "\[Rule]", "172700.00000000006`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.842572893577851*^9, {3.8425729933280663`*^9, 3.8425730201561136`*^9}, 
   3.8425784566677833`*^9, 3.8425788037974854`*^9, 3.842580768735512*^9, 
   3.8425823306736417`*^9, 3.842582491980098*^9, 3.8425829977095394`*^9, 
   3.842583294567149*^9, 3.842583380132677*^9, 3.842583476847294*^9, 
   3.8425835373760266`*^9, {3.842583764047378*^9, 3.8425837736527147`*^9}, {
   3.8425838123413444`*^9, 3.842583840270074*^9}, 3.8425839012360125`*^9, {
   3.8425840591913414`*^9, 3.8425840732140846`*^9}, 3.8425842626567326`*^9, {
   3.84258435669188*^9, 3.842584376813718*^9}, 3.8425845989237895`*^9, 
   3.8425847127148466`*^9, 3.842584915402176*^9, 3.84258495280613*^9, 
   3.8425850893964877`*^9, {3.8425851830408726`*^9, 3.84258519744343*^9}, 
   3.842591339063136*^9, 3.842591498017952*^9, 3.842591612663389*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"10ece405-1866-4168-89a9-596429252861"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.842254810874648*^9, 3.8422548974059987`*^9}, {
  3.8422676337491627`*^9, 3.8422676832183785`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"b1707b3e-5578-4766-8b7a-0f0e751f7a83"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n0", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "vn0", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"vM", "[", 
         RowBox[{"[", "l", "]"}], "]"}], "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"vn0", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "[", 
          RowBox[{"[", "l", "]"}], "]"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"l", ",", 
         RowBox[{"Length", "[", "vM", "]"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "n0"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "v2"}], "Input",
 CellChangeTimes->{{3.8422679296873384`*^9, 3.842267931796543*^9}, {
   3.842267978999792*^9, 3.8422680588905454`*^9}, 3.842268107671399*^9, {
   3.8422682163122945`*^9, 3.8422682168437185`*^9}, {3.8422686362964277`*^9, 
   3.8422686537967253`*^9}, 3.8422699806248474`*^9, 3.842572540890607*^9},
 CellLabel->"In[74]:=",ExpressionUUID->"e0e02068-08af-490f-8587-42f223fc6c58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "0.707104955518709`"}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.3526247779363332`"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", "0.3526247779363333`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}], "\[Rule]", "0.0009276998230211337`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "5"}], "]"}], "\[Rule]", 
      RowBox[{"-", "2.328838989977559`*^-16"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.3544801775823754`"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}], "\[Rule]", "0.3544801775823751`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.0009276998230210087`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "0.0016068232276452354`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.4090506480278676`"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", "0.4090506480278675`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"2", ",", "3"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.4082472364140449`"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "5"}], "]"}], "\[Rule]", 
      RowBox[{"-", "2.2997901796730586`*^-17"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"3", ",", "4"}], "]"}], "\[Rule]", "0.4074438248002224`"}], 
     ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "4"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.40744382480022256`"}]}], ",", 
     RowBox[{
      RowBox[{"m", "[", 
       RowBox[{"4", ",", "3"}], "]"}], "\[Rule]", "0.4082472364140446`"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8422682169997816`*^9, 3.8422683178282995`*^9, 3.8422686549997644`*^9, 
   3.8422688331716547`*^9, {3.84226993243734*^9, 3.84226998074975*^9}, 
   3.84227001843727*^9, 3.8422700543902817`*^9, {3.8422700886872706`*^9, 
   3.842270109531047*^9}, 3.842270611046976*^9, 3.842270938875152*^9, 
   3.842270979687484*^9, 3.842271117280917*^9, {3.8422712288125553`*^9, 
   3.842271250140502*^9}, 3.8423196617900963`*^9, 3.8423672117354016`*^9, 
   3.8423673829857297`*^9, 3.8423675749853983`*^9, 3.8423676160794077`*^9, 
   3.8423678715483484`*^9, 3.842406837461213*^9, 3.8424084734644046`*^9, 
   3.842408563664955*^9, 3.842408688790474*^9, 3.842408797212263*^9, 
   3.842408940528887*^9, 3.842409720904422*^9, 3.8424098518448496`*^9, 
   3.8424099349703074`*^9, 3.84241002830555*^9, 3.8424105015348477`*^9, 
   3.842410540390522*^9, {3.8424105965488577`*^9, 3.842410619188919*^9}, 
   3.8424107748762617`*^9, 3.842411455541975*^9, 3.842411712929701*^9, {
   3.842424241165832*^9, 3.8424242524627056`*^9}, 3.842424449618704*^9, {
   3.8424244927439404`*^9, 3.842424514665615*^9}, 3.842444435322014*^9, 
   3.842444775337758*^9, 3.842444847462654*^9, 3.842444882759341*^9, 
   3.8424449184468765`*^9, 3.842445076931492*^9, 3.8424451677750096`*^9, {
   3.842445206165702*^9, 3.842445224025072*^9}, 3.8424452560251665`*^9, 
   3.842445354134432*^9, 3.842445406981964*^9, 3.8424454661970997`*^9, 
   3.8424457778376107`*^9, 3.8424467555874043`*^9, 3.8424470677282534`*^9, 
   3.842447330853361*^9, 3.8424476518530536`*^9, 3.8424479318532734`*^9, 
   3.8424479764468746`*^9, 3.8424481859001837`*^9, 3.8424482912595453`*^9, {
   3.842448384462459*^9, 3.8424484032595787`*^9}, {3.842448680212567*^9, 
   3.842448697353181*^9}, 3.842448946259575*^9, 3.8424490976969547`*^9, 
   3.8424492325406694`*^9, {3.842449318853394*^9, 3.8424493414155583`*^9}, 
   3.842449428743941*^9, 3.842449511103221*^9, 3.842572246281081*^9, 
   3.8425723218435755`*^9, 3.842572509687274*^9, 3.8425725417184944`*^9, 
   3.8425726225155673`*^9, 3.842572811562591*^9, {3.8425729933592653`*^9, 
   3.842573020187247*^9}, 3.8425784567146473`*^9, 3.8425788038912144`*^9, 
   3.842580768782406*^9, 3.842582330736128*^9, 3.8425824920339727`*^9, 
   3.842582997765247*^9, 3.8425832946296177`*^9, 3.842583380179552*^9, 
   3.8425834768941584`*^9, 3.8425835374228935`*^9, {3.8425837640942464`*^9, 
   3.8425837737297964`*^9}, {3.8425838123726177`*^9, 3.8425838403325863`*^9}, 
   3.8425839012828784`*^9, {3.8425840592418904`*^9, 3.8425840732720857`*^9}, 
   3.842584262719245*^9, {3.8425843567387495`*^9, 3.8425843768605824`*^9}, 
   3.842584598986286*^9, 3.842584712761731*^9, 3.842584915451459*^9, 
   3.842584952852996*^9, 3.8425850894589744`*^9, {3.8425851830692854`*^9, 
   3.8425851975059156`*^9}, 3.8425913391132174`*^9, 3.842591498053362*^9, 
   3.842591612713333*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"373c249d-2c09-468b-8bfc-f1f4e900230f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"ecuaciones", " ", "de", " ", "compatibilidad"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ecs", "=", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "n0", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", 
     RowBox[{
      RowBox[{"k", "=", "1"}], ",", 
      RowBox[{"k", "\[LessEqual]", "n0"}], ",", 
      RowBox[{"k", "++"}], ",", 
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"b", "=", "1"}], ",", 
          RowBox[{"b", "<=", "nb"}], ",", 
          RowBox[{"b", "++"}], ",", 
          RowBox[{"{", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"i", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"barras", "[", 
                RowBox[{"[", "b", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"j", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"barras", "[", 
                RowBox[{"[", "b", "]"}], "]"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"L", "=", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"xy", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", 
                   RowBox[{
                    RowBox[{"xy", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"xy", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", 
                   RowBox[{
                    RowBox[{"xy", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], 
               ")"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"ecs", "[", 
              RowBox[{"[", "k", "]"}], "]"}], "+=", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"PFV1", "[", 
                  RowBox[{
                   RowBox[{"-", 
                    RowBox[{"Mz", "[", 
                    RowBox[{"b", ",", "i"}], "]"}]}], ",", 
                   RowBox[{"Mz", "[", 
                    RowBox[{"b", ",", "j"}], "]"}], ",", 
                   RowBox[{"-", 
                    RowBox[{"m", "[", 
                    RowBox[{"b", ",", "i"}], "]"}]}], ",", 
                   RowBox[{"m", "[", 
                    RowBox[{"b", ",", "j"}], "]"}], ",", "L", ",", 
                   RowBox[{"vE", " ", "Iy"}]}], "]"}], "/.", 
                 RowBox[{"sol", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
                RowBox[{"v2", "[", 
                 RowBox[{"[", "k", "]"}], "]"}]}], "//.", "datos"}], ")"}]}], 
            ";"}], "\[IndentingNewLine]", "}"}]}], "\[IndentingNewLine]", 
         "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ecs", "[", 
          RowBox[{"[", "k", "]"}], "]"}], "+=", 
         RowBox[{
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"vM", "[", 
              RowBox[{"[", "l", "]"}], "]"}], 
             RowBox[{"v\[Theta]", "[", 
              RowBox[{"[", "l", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"l", ",", 
              RowBox[{"Length", "[", "v\[Theta]", "]"}]}], "}"}]}], "]"}], 
          "\[IndentingNewLine]", "/.", 
          RowBox[{"v2", "[", 
           RowBox[{"[", "k", "]"}], "]"}]}]}], ";"}], "}"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ecs", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ecs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "ecs", "]"}]}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7561131882432003`*^9, 3.7561132833720007`*^9}, {
   3.758188259802106*^9, 3.7581883243531055`*^9}, {3.7581884644831057`*^9, 
   3.7581884655081053`*^9}, {3.7893645461659527`*^9, 
   3.7893645933819523`*^9}, {3.7893647057739525`*^9, 
   3.7893647698989525`*^9}, {3.7893661453869524`*^9, 
   3.7893661490109525`*^9}, {3.7893734959084525`*^9, 
   3.7893735512994523`*^9}, {3.7893947600562077`*^9, 
   3.7893947916092076`*^9}, {3.79100857039246*^9, 3.791008662636261*^9}, {
   3.7910087881774616`*^9, 3.7910087902834616`*^9}, {3.7910088385810623`*^9, 
   3.791008838877462*^9}, {3.822058767597228*^9, 3.8220588038204284`*^9}, {
   3.8220589700394297`*^9, 3.8220590259186296`*^9}, {3.822060128325837*^9, 
   3.822060136359837*^9}, {3.831860025605018*^9, 3.831860026701371*^9}, {
   3.83186011661689*^9, 3.8318601498515096`*^9}, {3.83186024890289*^9, 
   3.8318602734450045`*^9}, {3.831860310784752*^9, 3.831860334367098*^9}, {
   3.8416367773959417`*^9, 3.841636815020996*^9}, {3.8416372658332663`*^9, 
   3.8416372683801794`*^9}, {3.8416373094582496`*^9, 
   3.8416373183489733`*^9}, {3.8416373696617675`*^9, 3.841637373239646*^9}, {
   3.8416383816301985`*^9, 3.8416384569584208`*^9}, 3.8416385934116693`*^9, {
   3.8416387175055237`*^9, 3.841638718442851*^9}, {3.841640491083463*^9, 
   3.841640630114997*^9}, {3.8416414544768972`*^9, 3.841641487054556*^9}, {
   3.841641524992174*^9, 3.841641557710924*^9}, {3.84164166828909*^9, 
   3.8416416742265167`*^9}, {3.8416693927887807`*^9, 
   3.8416694045859375`*^9}, {3.841669466273096*^9, 3.841669513804612*^9}, {
   3.8416695797733603`*^9, 3.8416695991174293`*^9}, {3.841669634351554*^9, 
   3.8416696377890635`*^9}, 3.8416697103363934`*^9, {3.8416704406640167`*^9, 
   3.8416704596015654`*^9}, {3.8416705070231667`*^9, 3.841670528133089*^9}, {
   3.8422287551395483`*^9, 3.842228802889933*^9}, {3.8422549388590813`*^9, 
   3.842254966171569*^9}, {3.8422550020466204`*^9, 3.84225518800019*^9}, {
   3.842255240593465*^9, 3.8422553008277984`*^9}, {3.842255501109069*^9, 
   3.8422555638750906`*^9}, {3.842255603421644*^9, 3.842255731718737*^9}, {
   3.842255780280939*^9, 3.84225586867205*^9}, {3.8422561755777693`*^9, 
   3.8422561882811112`*^9}, {3.84226746395288*^9, 3.842267505921733*^9}, {
   3.842267552640234*^9, 3.8422675630625196`*^9}, {3.8422676803435364`*^9, 
   3.842267720280961*^9}, {3.8422677514215527`*^9, 3.8422677654997187`*^9}, {
   3.8422678244840097`*^9, 3.842267824734316*^9}, {3.842267883546858*^9, 
   3.84226788759362*^9}, {3.842267954452856*^9, 3.8422679572186003`*^9}, {
   3.8422680161091*^9, 3.8422680174843626`*^9}, {3.84226814037462*^9, 
   3.842268199906285*^9}, {3.8422684989687786`*^9, 3.842268527343874*^9}, {
   3.8422686905465417`*^9, 3.8422687157340097`*^9}, {3.8422688917652674`*^9, 
   3.8422688937651887`*^9}, {3.8422695262031584`*^9, 3.842269566124697*^9}, {
   3.8422702262032814`*^9, 3.8422703089219885`*^9}, {3.8422704220936985`*^9, 
   3.8422704616873646`*^9}, {3.8422704933280344`*^9, 
   3.8422705174997234`*^9}, {3.84227055681213*^9, 3.842270557109193*^9}, {
   3.842270849437559*^9, 3.842270887187659*^9}, {3.8423676993915467`*^9, 
   3.8423677051574774`*^9}, {3.8423677499697742`*^9, 3.842367760313789*^9}, {
   3.842408919085322*^9, 3.842408922350182*^9}, {3.8424090089647613`*^9, 
   3.842409038324679*^9}, {3.8424090900351896`*^9, 3.8424091534510503`*^9}, {
   3.842410582939349*^9, 3.842410589390956*^9}, 3.84241147607843*^9, {
   3.8424461404784555`*^9, 3.8424461609624586`*^9}, {3.8424470958530407`*^9, 
   3.842447103150064*^9}, {3.8425728302183733`*^9, 3.8425728419685245`*^9}, {
   3.8425842357928824`*^9, 3.8425842413697033`*^9}, {3.842585178905037*^9, 
   3.8425851958526974`*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"73b2bc27-aed3-4487-8404-b582c029773d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "0.015421970549994746`"}], "+", 
     RowBox[{"0.707104955518709`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "-", 
     RowBox[{"0.3526247779363332`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "+", 
     RowBox[{"0.3526247779363333`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}], "+", 
     RowBox[{"0.0009276998230211337`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "3"}], "]"}]}], "-", 
     RowBox[{"0.3544801775823754`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "4"}], "]"}]}], "-", 
     RowBox[{"2.328838989977559`*^-16", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "5"}], "]"}]}], "-", 
     RowBox[{"0.0009276998230210087`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "3"}], "]"}]}], "+", 
     RowBox[{"0.3544801775823751`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "0.015652770739557106`"}], "+", 
     RowBox[{"0.0016068232276452354`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "-", 
     RowBox[{"0.4090506480278676`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "+", 
     RowBox[{"0.4090506480278675`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}], "-", 
     RowBox[{"0.4082472364140449`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "3"}], "]"}]}], "+", 
     RowBox[{"0.4074438248002224`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "4"}], "]"}]}], "-", 
     RowBox[{"2.2997901796730586`*^-17", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "5"}], "]"}]}], "+", 
     RowBox[{"0.4082472364140446`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "3"}], "]"}]}], "-", 
     RowBox[{"0.40744382480022256`", " ", 
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "4"}], "]"}]}]}], "\[Equal]", "0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.842269583109037*^9, 3.8422699325310125`*^9, 3.842270122687583*^9, {
   3.8422704405466385`*^9, 3.8422704626405153`*^9}, {3.842270494874731*^9, 
   3.842270517640383*^9}, 3.8422705693122125`*^9, 3.8422706111403265`*^9, {
   3.8422708501251135`*^9, 3.842270887874983*^9}, 3.842270939015281*^9, 
   3.842270979812335*^9, 3.842271122218442*^9, {3.8422711594684863`*^9, 
   3.842271250218712*^9}, 3.842319661915039*^9, 3.8423672119385567`*^9, {
   3.8423676288760347`*^9, 3.842367648704571*^9}, {3.842367700188908*^9, 
   3.842367705751336*^9}, 3.8423677611261053`*^9, 3.842367871657647*^9, 
   3.8424068376174498`*^9, 3.8424088021329875`*^9, 3.8424088390144925`*^9, {
   3.842408923115589*^9, 3.842408940607024*^9}, 3.842409038496461*^9, {
   3.8424091230820417`*^9, 3.8424091541071053`*^9}, 3.8424097209669065`*^9, 
   3.842409851922955*^9, 3.8424099350484457`*^9, 3.842410028383685*^9, 
   3.8424105016129494`*^9, 3.8424105404686604`*^9, {3.8424105903906894`*^9, 
   3.842410619267029*^9}, 3.842410774954401*^9, {3.842411459195724*^9, 
   3.8424114774409904`*^9}, 3.8424117130078*^9, {3.842424241275322*^9, 
   3.842424252540604*^9}, 3.8424244496971006`*^9, {3.8424244928061905`*^9, 
   3.8424245147281237`*^9}, 3.8424444354000278`*^9, 3.842444783087467*^9, 
   3.8424448475875726`*^9, 3.84244488285306*^9, 3.842444918540903*^9, 
   3.842445076993887*^9, 3.842445167837529*^9, {3.842445206228107*^9, 
   3.842445224087759*^9}, 3.842445256087432*^9, 3.842445354196911*^9, 
   3.842445407040539*^9, 3.842445466244136*^9, 3.8424457778845987`*^9, {
   3.842446140790516*^9, 3.842446161165595*^9}, 3.842446755634513*^9, 
   3.8424471120409956`*^9, 3.8424473309002295`*^9, 3.842447651915701*^9, 
   3.8424479319001956`*^9, 3.8424479764936924`*^9, 3.842448185978343*^9, 
   3.842448291306465*^9, {3.8424483845093412`*^9, 3.842448403306275*^9}, {
   3.8424486802596087`*^9, 3.842448697399907*^9}, 3.842448946322132*^9, 
   3.842449097743868*^9, 3.8424492326031747`*^9, {3.842449319024988*^9, 
   3.8424493416345644`*^9}, 3.8424495111500025`*^9, 3.842572246359248*^9, 
   3.842572321906048*^9, 3.842572509765422*^9, 3.842572548202849*^9, 
   3.842572622546641*^9, {3.842572831265753*^9, 3.842572842671752*^9}, {
   3.842572993405979*^9, 3.842573020265736*^9}, 3.842578456761512*^9, 
   3.842578804047463*^9, 3.8425807688136387`*^9, 3.8425823307986126`*^9, 
   3.8425824920846167`*^9, 3.842582997812146*^9, 3.842583294676484*^9, 
   3.8425833802264366`*^9, 3.8425834769878855`*^9, 3.8425835375166206`*^9, {
   3.8425837642035904`*^9, 3.842583773839176*^9}, {3.842583812419465*^9, 
   3.8425838403794255`*^9}, 3.8425839013297405`*^9, {3.842584059288725*^9, 
   3.8425840733189554`*^9}, 3.8425842627628098`*^9, {3.8425843568011975`*^9, 
   3.8425843769386888`*^9}, 3.842584599048778*^9, 3.842584712792984*^9, 
   3.842584915498358*^9, 3.842584952899892*^9, 3.842585089505865*^9, {
   3.842585183116149*^9, 3.84258519755278*^9}, 3.8425913391629157`*^9, 
   3.8425914980930643`*^9, 3.8425916127583237`*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"dd97b30a-db94-4715-909a-9903111761c6"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.842248168750027*^9, {3.8424461044623737`*^9, 3.8424461355093074`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"0e32202b-72b6-4320-bf4e-417dfb2a4cc0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Edisp", "=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"rM", "[", 
       RowBox[{"[", "i", "]"}], "]"}], 
      RowBox[{"v\[Theta]", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "rM", "]"}]}], "}"}]}], "]"}], "/.", 
   "v1"}]}], "\[IndentingNewLine]", 
 RowBox[{"cd", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"rM", "[", 
         RowBox[{"[", "i", "]"}], "]"}], 
        RowBox[{"v\[Theta]", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "rM", "]"}]}], "}"}]}], "]"}], "/.", 
    RowBox[{"sol", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "/.", "v1"}]}]}], "Input",
 CellChangeTimes->{{3.8418988353683558`*^9, 3.841898880348477*^9}, {
   3.8418989104184628`*^9, 3.841898933163458*^9}, {3.8418989853986053`*^9, 
   3.8418990010985904`*^9}, {3.841899093348872*^9, 3.8418991119338117`*^9}, {
   3.8418991460685415`*^9, 3.8418991767887526`*^9}, {3.8418992234687767`*^9, 
   3.8418993112986073`*^9}, 3.8418995980687637`*^9, 3.8418996499693394`*^9, 
   3.8418996972090034`*^9, {3.8418999846190243`*^9, 3.8419000212090607`*^9}, {
   3.8419000659092035`*^9, 3.8419000718191595`*^9}, {3.8419001106842856`*^9, 
   3.8419001173695292`*^9}, {3.8419001845492067`*^9, 3.841900188455536*^9}, {
   3.841900372089691*^9, 3.841900382219395*^9}, {3.841900417599639*^9, 
   3.8419005613496256`*^9}, {3.841900639459631*^9, 3.8419006405896335`*^9}, 
   3.841900777049904*^9, {3.8419008111349535`*^9, 3.8419008312999053`*^9}, 
   3.8419009090972214`*^9, {3.841900950289784*^9, 3.841901019049756*^9}, {
   3.84190142491024*^9, 3.84190144281001*^9}, 3.841901642435171*^9, 
   3.841902065170272*^9, {3.841902211660615*^9, 3.84190230145076*^9}, {
   3.8419024030609283`*^9, 3.841902450305175*^9}, {3.8419024932707586`*^9, 
   3.8419024933910007`*^9}, 3.8419025940456147`*^9, {3.841902664990737*^9, 
   3.841902665071019*^9}, {3.841902898551288*^9, 3.841902964525906*^9}, {
   3.841903026831172*^9, 3.841903065731233*^9}, {3.841903148416181*^9, 
   3.8419031693011913`*^9}, {3.841903252791512*^9, 3.8419032744714346`*^9}, {
   3.8419033450560193`*^9, 3.841903384581313*^9}, {3.8419034398015547`*^9, 
   3.8419035605266056`*^9}, {3.841903620471507*^9, 3.8419036433416433`*^9}, {
   3.8419037112104373`*^9, 3.8419037628516703`*^9}, {3.8419038066118336`*^9, 
   3.841903806731665*^9}, 3.8419038631518936`*^9, {3.8419039300427914`*^9, 
   3.8419039626518497`*^9}, {3.8421819177489395`*^9, 3.842182083170862*^9}, {
   3.842182146639205*^9, 3.8421821472177258`*^9}, {3.8421822255145817`*^9, 
   3.842182263889617*^9}, 3.8421823096396394`*^9, {3.842228826811458*^9, 
   3.842228828655199*^9}, {3.842228867780235*^9, 3.8422290796708*^9}, {
   3.84222911273337*^9, 3.842229113452094*^9}, {3.842229200045987*^9, 
   3.8422293425771446`*^9}, {3.8422479309061537`*^9, 3.842247934234252*^9}, {
   3.842247994484133*^9, 3.8422480489687185`*^9}, {3.842248089578066*^9, 
   3.842248131577993*^9}, {3.84225589224969*^9, 3.8422558923435144`*^9}, {
   3.8422559230465417`*^9, 3.8422560082969275`*^9}, {3.842256038671532*^9, 
   3.8422560393590703`*^9}, {3.842256070108919*^9, 3.842256146234131*^9}, {
   3.8422562052965717`*^9, 3.842256226374755*^9}, {3.842268945077797*^9, 
   3.842269001171593*^9}, 3.8422690509372425`*^9, {3.842269149484133*^9, 
   3.842269181297017*^9}, {3.842269289624764*^9, 3.842269306827863*^9}, {
   3.8422693673903685`*^9, 3.8422693852809663`*^9}, {3.842269427843508*^9, 
   3.842269485328277*^9}, {3.8422695953592176`*^9, 3.842269616249688*^9}, {
   3.8422696613750677`*^9, 3.842269672702813*^9}, {3.84226971421844*^9, 
   3.842269721546442*^9}, 3.8422706988169904`*^9, 3.842270745156373*^9, {
   3.8422707832495985`*^9, 3.842270832609047*^9}, {3.8424088821069183`*^9, 
   3.8424088930917177`*^9}, {3.842409165741*^9, 3.8424093033331966`*^9}, {
   3.8424093412180233`*^9, 3.8424093608877597`*^9}, 3.842409465713997*^9, {
   3.8424095170840297`*^9, 3.842409554855444*^9}, {3.8424095997724075`*^9, 
   3.842409625718567*^9}, {3.842409661342865*^9, 3.842409666326079*^9}, {
   3.842409736742107*^9, 3.842409837736141*^9}, {3.84240988855238*^9, 
   3.842409926087369*^9}, {3.842409963124073*^9, 3.8424099936850915`*^9}, {
   3.842410210250024*^9, 3.8424102585476933`*^9}, {3.8424115735301514`*^9, 
   3.8424115811563525`*^9}, {3.842411737812656*^9, 3.8424117710863733`*^9}, {
   3.8424450706186533`*^9, 3.8424450736343327`*^9}, {3.842445146868714*^9, 
   3.8424451644002085`*^9}, {3.842445200509327*^9, 3.842445203134247*^9}, {
   3.8424452403378468`*^9, 3.8424452519626417`*^9}, {3.842445458602985*^9, 
   3.8424454631346035`*^9}, 3.84244625229062*^9, 3.8424463090879335`*^9, 
   3.8424471193220587`*^9, {3.8424472877337484`*^9, 3.842447299634256*^9}, {
   3.8424473772594023`*^9, 3.842447403493722*^9}, {3.842447439712537*^9, 
   3.8424474669784207`*^9}, {3.8424476442280397`*^9, 3.842447647493658*^9}, {
   3.842449090588335*^9, 3.8424490942909265`*^9}, {3.8425725643121853`*^9, 
   3.842572566578048*^9}, {3.842572946437538*^9, 3.842572971765855*^9}, {
   3.8425730137495785`*^9, 3.842573038890354*^9}, {3.8425830340220118`*^9, 
   3.84258303700568*^9}, {3.8425840233925*^9, 3.8425840398296747`*^9}, {
   3.842584110370664*^9, 3.8425841454578943`*^9}, {3.842584351926442*^9, 
   3.842584374781968*^9}, {3.8425844159033747`*^9, 3.842584416496992*^9}, {
   3.84258490813358*^9, 3.842584908258563*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"82b85410-2586-45fa-bafa-b76c161994b9"],

Cell[BoxData[
 RowBox[{"0.`", "\[VeryThinSpace]", "-", 
  RowBox[{"115133.33333333333`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"1", ",", "1"}], "]"}]}], "+", 
  RowBox[{"172700.`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "-", 
  RowBox[{"172700.`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"2", ",", "2"}], "]"}]}], "-", 
  RowBox[{"172700.00000000006`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"2", ",", "3"}], "]"}]}], "-", 
  RowBox[{"172700.`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "+", 
  RowBox[{"172700.00000000006`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"4", ",", "3"}], "]"}]}], "+", 
  RowBox[{"172700.`", " ", 
   RowBox[{"\[Theta]", "[", 
    RowBox[{"4", ",", "4"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.842447384196822*^9, 3.842447404056592*^9}, {
   3.8424474425405035`*^9, 3.8424474675409355`*^9}, {3.842447647712658*^9, 
   3.842447651993743*^9}, 3.842447931993742*^9, 3.842447976587425*^9, 
   3.842448186072051*^9, 3.842448291400137*^9, {3.8424483846031227`*^9, 
   3.8424484034000177`*^9}, {3.8424486803534822`*^9, 3.8424486974941397`*^9}, 
   3.8424489464156623`*^9, 3.8424490978377495`*^9, 3.8424492326658173`*^9, {
   3.8424493192597127`*^9, 3.84244934193145*^9}, 3.842449511243699*^9, 
   3.842572246546986*^9, 3.8425723219842873`*^9, 3.8425725099059906`*^9, 
   3.8425725669216547`*^9, 3.8425726225783176`*^9, 3.842572898827862*^9, {
   3.8425729466091022`*^9, 3.8425730396564584`*^9}, 3.842578456777133*^9, 
   3.8425788041568007`*^9, 3.84258076883851*^9, 3.8425823308610983`*^9, 
   3.8425824921627216`*^9, 3.842582997859002*^9, 3.842583041239057*^9, 
   3.842583294738967*^9, 3.842583380299062*^9, 3.842583477065993*^9, 
   3.8425835375947294`*^9, {3.8425837642660627`*^9, 3.8425837739016647`*^9}, {
   3.8425838124350924`*^9, 3.84258384044191*^9}, 3.842583901376577*^9, 
   3.8425839960051327`*^9, {3.842584026329275*^9, 3.8425840733658185`*^9}, {
   3.842584133995774*^9, 3.8425841462545724`*^9}, 3.842584262809675*^9, {
   3.8425843546601677`*^9, 3.842584376985553*^9}, 3.8425845990956116`*^9, 
   3.842584712839838*^9, 3.842584915576432*^9, 3.842584952977965*^9, 
   3.842585089568349*^9, {3.8425851831704335`*^9, 3.8425851976308823`*^9}, 
   3.8425913392131433`*^9, 3.842591498133154*^9, 3.842591612825642*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"05b8224e-6e14-4a7a-96ee-cdf6ee2ac580"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "115133.33333333333`"}], " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"1", ",", "1"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"172700.`", " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"1", ",", "2"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "172700.`"}], " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"2", ",", "2"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "172700.00000000006`"}], " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"2", ",", "3"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", "True",
    ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "172700.`"}], " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"3", ",", "4"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"172700.`", " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"4", ",", "4"}], "]"}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{
    RowBox[{"172700.00000000006`", " ", 
     RowBox[{"\[Theta]", "[", 
      RowBox[{"4", ",", "3"}], "]"}]}], "\[GreaterEqual]", "0"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.842447384196822*^9, 3.842447404056592*^9}, {
   3.8424474425405035`*^9, 3.8424474675409355`*^9}, {3.842447647712658*^9, 
   3.842447651993743*^9}, 3.842447931993742*^9, 3.842447976587425*^9, 
   3.842448186072051*^9, 3.842448291400137*^9, {3.8424483846031227`*^9, 
   3.8424484034000177`*^9}, {3.8424486803534822`*^9, 3.8424486974941397`*^9}, 
   3.8424489464156623`*^9, 3.8424490978377495`*^9, 3.8424492326658173`*^9, {
   3.8424493192597127`*^9, 3.84244934193145*^9}, 3.842449511243699*^9, 
   3.842572246546986*^9, 3.8425723219842873`*^9, 3.8425725099059906`*^9, 
   3.8425725669216547`*^9, 3.8425726225783176`*^9, 3.842572898827862*^9, {
   3.8425729466091022`*^9, 3.8425730396564584`*^9}, 3.842578456777133*^9, 
   3.8425788041568007`*^9, 3.84258076883851*^9, 3.8425823308610983`*^9, 
   3.8425824921627216`*^9, 3.842582997859002*^9, 3.842583041239057*^9, 
   3.842583294738967*^9, 3.842583380299062*^9, 3.842583477065993*^9, 
   3.8425835375947294`*^9, {3.8425837642660627`*^9, 3.8425837739016647`*^9}, {
   3.8425838124350924`*^9, 3.84258384044191*^9}, 3.842583901376577*^9, 
   3.8425839960051327`*^9, {3.842584026329275*^9, 3.8425840733658185`*^9}, {
   3.842584133995774*^9, 3.8425841462545724`*^9}, 3.842584262809675*^9, {
   3.8425843546601677`*^9, 3.842584376985553*^9}, 3.8425845990956116`*^9, 
   3.842584712839838*^9, 3.842584915576432*^9, 3.842584952977965*^9, 
   3.842585089568349*^9, {3.8425851831704335`*^9, 3.8425851976308823`*^9}, 
   3.8425913392131433`*^9, 3.842591498133154*^9, 3.842591612825642*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"1b875078-830a-4c8f-b3d9-e322acca3cdd"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"val", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"i", "=", "1"}], ",", 
   RowBox[{"i", "\[LessEqual]", 
    RowBox[{"Length", "[", "v\[Theta]", "]"}]}], ",", 
   RowBox[{"i", "++"}], ",", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"v1", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "-", " ", 
          RowBox[{"0.99", "Mp"}]}], ")"}], ">", " ", 
        RowBox[{"10", "^", 
         RowBox[{"-", "4"}]}]}], "//.", "datos"}], ",", ",", 
      RowBox[{"val", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"val", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"v\[Theta]", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "\[Equal]", "0"}], "}"}]}], 
        "]"}]}]}], "]"}], "\[IndentingNewLine]", "}"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.8425730429063196`*^9, 3.8425731119845123`*^9}, {
   3.842573150218734*^9, 3.8425732807967434`*^9}, 3.842573447734078*^9, {
   3.8425737598747463`*^9, 3.8425737612968855`*^9}, {3.84257382857784*^9, 
   3.842573853000185*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"9e8bb089-05d0-49cd-a591-a76a8f40dade"],

Cell[CellGroupData[{

Cell[BoxData["val"], "Input",
 CellChangeTimes->{{3.84257325776541*^9, 3.842573258093562*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"7c4d0961-cfbb-414d-8556-4aa58b88f48e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Theta]", "[", 
     RowBox[{"1", ",", "1"}], "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{"\[Theta]", "[", 
     RowBox[{"3", ",", "5"}], "]"}], "\[Equal]", "0"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.842573258875105*^9, 3.8425732874220443`*^9}, 
   3.8425734496715794`*^9, {3.8425738086715956`*^9, 3.842573855046584*^9}, 
   3.8425784568239965`*^9, 3.842578804250536*^9, 3.8425807689010286`*^9, 
   3.842582331032964*^9, 3.8425824923172474`*^9, 3.8425829979683285`*^9, 
   3.8425830413327613`*^9, 3.8425832948483176`*^9, 3.8425833803771734`*^9, 
   3.8425834771909657`*^9, 3.8425835377352905`*^9, {3.8425837644222965`*^9, 
   3.842583774042226*^9}, {3.8425838125288315`*^9, 3.8425838405668817`*^9}, 
   3.842583901470331*^9, 3.8425839961144824`*^9, {3.8425840313437557`*^9, 
   3.8425840734595747`*^9}, {3.8425841389164753`*^9, 3.8425841516908035`*^9}, 
   3.8425842629034023`*^9, {3.8425843569730673`*^9, 3.8425843770949025`*^9}, {
   3.8425845917081356`*^9, 3.842584599267477*^9}, 3.8425846320280895`*^9, {
   3.842584667851511*^9, 3.8425847422440233`*^9}, {3.8425847810827146`*^9, 
   3.8425848447246127`*^9}, 3.842584875741066*^9, 3.8425849156309347`*^9, 
   3.842584953024829*^9, 3.842585089646428*^9, {3.8425851832329254`*^9, 
   3.842585197682003*^9}, 3.8425913392650623`*^9, 3.84259149818291*^9, 
   3.842591612873369*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"0cbed928-88bd-458d-af5d-bf5b3b5ffc98"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.8424475206189036`*^9, 3.842447573665929*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"3b189ba1-c781-43e1-a610-dd1dfa75fbd2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol3", "=", 
  RowBox[{
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "Edisp", "}"}], ",", "ecs", ",", "cd", ",", "val"}], 
      "]"}], ",", "v\[Theta]"}], "]"}], "//", "Quiet"}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQ/e7B4ScXFrxxfBDn+wxE17tGfQPROvsPgenlxSl/
QLRU4py/IHpWxb3Oi0Ca6VN/F4i+o9i2AEQzx3xYCKILfY5cegikcwNu3QLR
Rd7z+B4B6W3+i8C02RldCRA97+QxaRA9x3ueNYie5XMPTEeeeeUEoh+eFvMH
0ctPe0WAaJHzddEg+s2JhgQQ7XDGOQlEp5zenwOifc+KFYLoPp/4ChC94MyX
KhCt5vP+EYhmDDB4BqIT/TZJPwbS6858kAfRZT5BwSDa/WwtmJ7vsz0KRF/y
vRILopW8IvJA9OozXkUg+sufe74KC4H6GAv9QPSmv6+OgWj1RslTIBoAIeXG
og==
  "],
 CellLabel->"In[87]:=",ExpressionUUID->"746d21ba-082b-4829-92e8-8cf178eae08f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21707.731133389047`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "1"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"1", ",", "2"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "2"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"2", ",", "3"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "5"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"3", ",", "4"}], "]"}], "\[Rule]", 
      RowBox[{"-", "0.043720412141464784`"}]}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "4"}], "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"\[Theta]", "[", 
       RowBox[{"4", ",", "3"}], "]"}], "\[Rule]", "0.08197577276524654`"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8424102647649727`*^9, 3.842410317203209*^9}, {
   3.8424104226950674`*^9, 3.8424105017066827`*^9}, 3.8424105405559845`*^9, {
   3.8424105967314863`*^9, 3.8424106194701023`*^9}, 3.842410775048128*^9, {
   3.8424115858907957`*^9, 3.842411604685708*^9}, 3.84241179199539*^9, {
   3.8424242413690987`*^9, 3.8424242526813173`*^9}, 3.842424449806245*^9, {
   3.842424492837456*^9, 3.8424245147593355`*^9}, 3.842444435478345*^9, 
   3.842444847712612*^9, 3.84244488293146*^9, 3.8424449186033955`*^9, {
   3.8424450156032596`*^9, 3.842445033290577*^9}, 3.842445077009512*^9, {
   3.8424451584157443`*^9, 3.84244516786869*^9}, {3.8424452063531504`*^9, 
   3.8424452241503325`*^9}, 3.8424452561499205`*^9, 3.842445354243696*^9, {
   3.842445407072045*^9, 3.8424454298534484`*^9}, 3.8424454662752705`*^9, {
   3.8424455343974743`*^9, 3.842445542649944*^9}, {3.8424457779312534`*^9, 
   3.8424457959472475`*^9}, 3.8424458425878515`*^9, 3.8424459492436757`*^9, 
   3.842446044228325*^9, {3.842446166399926*^9, 3.8424461936656427`*^9}, {
   3.842446295868745*^9, 3.842446313228479*^9}, 3.84244634519681*^9, 
   3.8424467556660132`*^9, 3.8424471555717754`*^9, {3.842447304212425*^9, 
   3.8424473309625845`*^9}, 3.842447380478054*^9, {3.842447445196862*^9, 
   3.8424474696031895`*^9}, {3.8424475997124405`*^9, 3.8424476185563283`*^9}, 
   3.842447652024938*^9, 3.8424479320562825`*^9, 3.842447976650131*^9, 
   3.8424480282749596`*^9, {3.8424480882283564`*^9, 3.842448112118745*^9}, 
   3.8424481861343365`*^9, {3.842448251040845*^9, 3.842448291446926*^9}, {
   3.8424483846656704`*^9, 3.8424484034627304`*^9}, {3.842448680415756*^9, 
   3.8424486975564675`*^9}, 3.8424489464782543`*^9, 3.842449097947284*^9, 
   3.842449232774968*^9, {3.8424493194625683`*^9, 3.8424493421968336`*^9}, 
   3.8424495114936705`*^9, 3.8425722468591213`*^9, 3.8425723220622573`*^9, 
   3.8425725100312166`*^9, 3.8425726226405525`*^9, 3.8425729167497373`*^9, {
   3.8425729889684772`*^9, 3.8425730204216557`*^9}, {3.84257388084375*^9, 
   3.842573933187524*^9}, 3.842574006781026*^9, 3.8425784570114827`*^9, 
   3.84257880447042*^9, 3.8425807690884876`*^9, 3.842582331142312*^9, 
   3.8425824924150457`*^9, 3.8425829980602264`*^9, 3.8425830413952765`*^9, 
   3.8425832949576674`*^9, 3.84258338046408*^9, 3.8425834773627977`*^9, 
   3.842583537863524*^9, {3.8425837645582886`*^9, 3.8425837741984735`*^9}, {
   3.8425838125855074`*^9, 3.842583840644989*^9}, 3.8425839015484095`*^9, 
   3.8425839961931086`*^9, {3.8425840314218626`*^9, 3.842584073537691*^9}, {
   3.842584138994605*^9, 3.8425841517773395`*^9}, 3.842584262965889*^9, {
   3.842584357019928*^9, 3.842584377176648*^9}, {3.842584591801876*^9, 
   3.842584599361205*^9}, 3.842584632132233*^9, {3.8425846679577446`*^9, 
   3.8425847423221607`*^9}, {3.842584781140316*^9, 3.842584844771447*^9}, 
   3.8425848758035235`*^9, 3.842584915709073*^9, 3.842584953102935*^9, 
   3.842585089726877*^9, {3.8425851833110614`*^9, 3.842585197763905*^9}, 
   3.842591339342857*^9, 3.8425914982478867`*^9, 3.84259161294337*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"5b87b25f-610d-4cbd-9d35-567681978d84"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"signo", " ", "menos"}], " ", "\[Rule]", " ", "horario"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8425849387898235`*^9, 3.8425849507298717`*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"9a754de6-bb99-4733-bb31-05aa3bcf54b3"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.842584977094656*^9},
 CellLabel->"In[89]:=",ExpressionUUID->"97363c80-4e6c-4d96-a806-a1f33a87b2e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "comprobar", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\[Theta]3", "=", 
    RowBox[{
     RowBox[{"5", "Mp", " ", 
      RowBox[{"L0", "/", 
       RowBox[{"(", 
        RowBox[{"3", "vE", " ", "Iy"}], ")"}]}]}], "//.", "datos"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"\[Theta]4", "=", 
    RowBox[{
     RowBox[{"8", "Mp", " ", 
      RowBox[{"L0", "/", 
       RowBox[{"(", 
        RowBox[{"9", "vE", " ", "Iy"}], ")"}]}]}], "//.", 
     "datos"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8425842873245125`*^9, 3.8425843191990542`*^9}, {
  3.842584981781096*^9, 3.8425850109787664`*^9}, {3.8425915384431443`*^9, 
  3.8425915824833026`*^9}},
 CellLabel->"In[90]:=",ExpressionUUID->"ff47a490-5502-40e1-94c1-d9afe9009c70"],

Cell[BoxData["0.08197577276524647`"], "Output",
 CellChangeTimes->{
  3.842584319808255*^9, {3.842584357101555*^9, 3.8425843772704077`*^9}, 
   3.8425845994705276`*^9, {3.842584688900483*^9, 3.842584713045046*^9}, 
   3.8425847811715755`*^9, {3.842584818374303*^9, 3.84258484483394*^9}, 
   3.842584875860463*^9, 3.84258491574831*^9, 3.8425849531538553`*^9, {
   3.842584993326643*^9, 3.84258501111935*^9}, 3.842585089804984*^9, {
   3.8425851833735466`*^9, 3.8425851978263874`*^9}, 3.842591339403162*^9, 
   3.8425914982931423`*^9, {3.842591542693362*^9, 3.842591612983018*^9}},
 CellLabel->"Out[90]=",ExpressionUUID->"5c6c9f0e-d574-4a29-8628-b0c12c483979"],

Cell[BoxData["0.04372041214146477`"], "Output",
 CellChangeTimes->{
  3.842584319808255*^9, {3.842584357101555*^9, 3.8425843772704077`*^9}, 
   3.8425845994705276`*^9, {3.842584688900483*^9, 3.842584713045046*^9}, 
   3.8425847811715755`*^9, {3.842584818374303*^9, 3.84258484483394*^9}, 
   3.842584875860463*^9, 3.84258491574831*^9, 3.8425849531538553`*^9, {
   3.842584993326643*^9, 3.84258501111935*^9}, 3.842585089804984*^9, {
   3.8425851833735466`*^9, 3.8425851978263874`*^9}, 3.842591339403162*^9, 
   3.8425914982931423`*^9, {3.842591542693362*^9, 3.842591612992893*^9}},
 CellLabel->"Out[91]=",ExpressionUUID->"93f80741-c84d-4de8-8a81-726918e9c69d"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.842584312999878*^9, 3.8425843147650948`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"da54a4d8-a594-4f58-b121-e8c887b1d2bb"]
},
WindowSize->{969, 816},
WindowMargins->{{118, Automatic}, {Automatic, 12}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.2 para Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6c0c5215-3d75-4ab8-9283-c38e243129bf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 140, 2, 28, "Input",ExpressionUUID->"41c6103b-0af5-44a6-8576-9ed0ee7275c3"],
Cell[701, 24, 321, 6, 28, "Input",ExpressionUUID->"5e6da543-c560-4ce5-b12c-3daa8af914d3"],
Cell[CellGroupData[{
Cell[1047, 34, 1356, 38, 102, "Input",ExpressionUUID->"d81600bd-def5-4563-a79c-10ed3fa32b9c"],
Cell[2406, 74, 4071, 73, 130, "Output",ExpressionUUID->"8398e883-fa7e-42d3-b20c-7834c60b20cd"]
}, Open  ]],
Cell[6492, 150, 172, 2, 28, "Input",ExpressionUUID->"37688275-b3f9-455e-b8b5-a17dcb797872"],
Cell[6667, 154, 7978, 123, 48, "Input",ExpressionUUID->"da5e7ff2-71c0-4208-9ac6-64204413a215"],
Cell[14648, 279, 172, 2, 28, "Input",ExpressionUUID->"84724aa0-2d74-4ac7-92c4-79bec652678e"],
Cell[14823, 283, 6330, 156, 333, "Input",ExpressionUUID->"212c7762-3035-4931-aabe-d35ddbf6cd4a"],
Cell[21156, 441, 577, 16, 103, "Input",ExpressionUUID->"b4150091-49b7-4fdd-8322-b6797d79d5a3"],
Cell[CellGroupData[{
Cell[21758, 461, 6750, 179, 519, "Input",ExpressionUUID->"28270041-c78d-4380-a5b4-952ada8ec8da"],
Cell[CellGroupData[{
Cell[28533, 644, 11005, 153, 22, "Print",ExpressionUUID->"5677a5f3-a333-4137-94be-3134065dba1e"],
Cell[39541, 799, 11120, 155, 24, "Print",ExpressionUUID->"1ab6d244-4620-48ee-b1f1-7af245411a22"],
Cell[50664, 956, 11122, 155, 24, "Print",ExpressionUUID->"6456d929-be39-4a48-a91d-845fd8701ca1"],
Cell[61789, 1113, 12485, 199, 107, "Print",ExpressionUUID->"f88c17ee-2ca6-4862-9bfe-c43c57415e53"],
Cell[74277, 1314, 11007, 153, 22, "Print",ExpressionUUID->"3de471da-28cf-499f-ad13-8043b7bb400c"],
Cell[85287, 1469, 11122, 155, 24, "Print",ExpressionUUID->"322b2182-9e35-402e-9fd8-8382b0c25c6e"],
Cell[96412, 1626, 11120, 155, 24, "Print",ExpressionUUID->"c93717fe-6469-472c-a413-ea58efe13703"],
Cell[107535, 1783, 12483, 199, 107, "Print",ExpressionUUID->"3e024298-8eb5-4272-a481-dab705b3b24a"],
Cell[120021, 1984, 11007, 153, 22, "Print",ExpressionUUID->"3ac4f250-b9f6-47d5-a2dc-9b1716691ed2"],
Cell[131031, 2139, 11122, 155, 24, "Print",ExpressionUUID->"5631328c-70fb-415a-94da-81f8c4fd5094"],
Cell[142156, 2296, 11122, 155, 24, "Print",ExpressionUUID->"a87dc13c-e497-482e-9a3f-7d7f34a8eb97"],
Cell[153281, 2453, 12485, 199, 107, "Print",ExpressionUUID->"9462cf02-87cc-4e88-85aa-7a83c61df5ca"],
Cell[165769, 2654, 11007, 153, 22, "Print",ExpressionUUID->"ba32c789-48f4-4ba4-a9d7-a771a68c5a92"],
Cell[176779, 2809, 11142, 156, 24, "Print",ExpressionUUID->"98207a04-186b-4a74-8969-1ebf49249761"],
Cell[187924, 2967, 11122, 155, 24, "Print",ExpressionUUID->"681b6947-9f53-43e4-82b6-26a267b677cb"],
Cell[199049, 3124, 12485, 199, 107, "Print",ExpressionUUID->"409e06f0-038b-4054-ab46-2f4060050733"]
}, Open  ]]
}, Open  ]],
Cell[211561, 3327, 166, 2, 48, "Input",ExpressionUUID->"998ab602-f887-4c22-b0eb-461a661d4878"],
Cell[CellGroupData[{
Cell[211752, 3333, 3185, 84, 533, "Input",ExpressionUUID->"5ed8cdf5-8891-4bed-940d-9fc322a00d72"],
Cell[214940, 3419, 15823, 291, 283, "Output",ExpressionUUID->"1fce71fa-9867-4c5c-9481-f10b7572069a"]
}, Open  ]],
Cell[230778, 3713, 166, 2, 48, "Input",ExpressionUUID->"bae5159a-521b-4194-a179-6ba48d07a108"],
Cell[CellGroupData[{
Cell[230969, 3719, 3219, 85, 421, "Input",ExpressionUUID->"b2554c15-6a45-4e62-be35-7445bc1a0b38"],
Cell[234191, 3806, 12698, 198, 283, "Output",ExpressionUUID->"922ffe88-2ba4-447f-ba9f-0c0c82152a64"],
Cell[246892, 4006, 12428, 195, 278, "Output",ExpressionUUID->"292d52cc-3ea9-4e69-b0aa-2344c7f22866"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259357, 4206, 1711, 54, 250, "Input",ExpressionUUID->"9258be79-c3e3-4d36-90b0-abe8e0b99de1"],
Cell[261071, 4262, 9059, 124, 32, "Output",ExpressionUUID->"54d2cea6-7948-4636-95e5-b44ee0b7147b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[270167, 4391, 456, 8, 66, "Input",ExpressionUUID->"9aa016e4-032f-40d2-b2fa-b2bc7f782a0e"],
Cell[270626, 4401, 8100, 189, 292, "Output",ExpressionUUID->"8f3cd6e5-814a-4cb6-b482-0655eb7b7246"]
}, Open  ]],
Cell[278741, 4593, 537, 16, 64, "Input",ExpressionUUID->"2069ffb2-65a9-4825-94b5-e42e64dfe1f9"],
Cell[279281, 4611, 173, 2, 28, "Input",ExpressionUUID->"8557a313-470c-431e-a925-239053f8ba6c"],
Cell[279457, 4615, 217, 3, 28, "Input",ExpressionUUID->"691f5174-c742-4651-b796-68e6e7838f6d"],
Cell[CellGroupData[{
Cell[279699, 4622, 659, 18, 45, "Input",ExpressionUUID->"dffc14e1-f2df-4f3f-849e-42ee6aff5afe"],
Cell[280361, 4642, 2366, 58, 52, "Output",ExpressionUUID->"71edacc7-3151-4a32-ab57-c80d3180db0c"]
}, Open  ]],
Cell[282742, 4703, 168, 2, 48, "Input",ExpressionUUID->"74a17246-a624-42e3-af83-3900bb349d0c"],
Cell[CellGroupData[{
Cell[282935, 4709, 2254, 64, 254, "Input",ExpressionUUID->"ae88a002-63cc-403c-93c9-0652965638cb"],
Cell[285192, 4775, 1656, 30, 32, "Output",ExpressionUUID->"6deefbf1-5a67-42ee-aa77-0253960b37d2"],
Cell[286851, 4807, 1699, 34, 32, "Output",ExpressionUUID->"c41fa4a1-cd56-46f7-b39f-7f307647a348"],
Cell[288553, 4843, 1346, 21, 32, "Output",ExpressionUUID->"19a8afbb-e237-4fdb-a62a-834dc14f3906"],
Cell[289902, 4866, 1348, 21, 32, "Output",ExpressionUUID->"de2661a1-42ac-4c05-82b7-c8965022d0f8"],
Cell[291253, 4889, 1346, 21, 32, "Output",ExpressionUUID->"9ee315da-2d10-4a5f-88f1-8e3ed160b7fa"],
Cell[292602, 4912, 1281, 19, 32, "Output",ExpressionUUID->"bee18bc2-71f3-4d95-be47-16df8a829b79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[293920, 4936, 268, 5, 45, "Input",ExpressionUUID->"b2fffffa-fd6d-4cb8-94a4-13ba54985213"],
Cell[294191, 4943, 4738, 129, 207, "Output",ExpressionUUID->"b8ef4c0f-9123-4f3b-abb2-d67edfd2b951"]
}, Open  ]],
Cell[298944, 5075, 166, 2, 48, "Input",ExpressionUUID->"1ef0eb2a-295c-4a81-891c-d32e392ec544"],
Cell[299113, 5079, 598, 19, 28, "Input",ExpressionUUID->"2c5f2cb3-ba4f-407a-b27e-feb2650d08fa"],
Cell[CellGroupData[{
Cell[299736, 5102, 5991, 156, 558, "Input",ExpressionUUID->"24c6ce91-8239-4e7c-9e60-53552b680125"],
Cell[305730, 5260, 3435, 58, 32, "Output",ExpressionUUID->"cddd559f-9e31-4d1a-9598-61843ecccfb0"],
Cell[309168, 5320, 3481, 58, 32, "Output",ExpressionUUID->"caca3c6a-7fb1-471c-8b9c-8a05c07bd469"]
}, Open  ]],
Cell[312664, 5381, 173, 2, 28, "Input",ExpressionUUID->"5ef367c0-0bb3-4b0a-8fa3-9564813ae358"],
Cell[CellGroupData[{
Cell[312862, 5387, 173, 2, 28, "Input",ExpressionUUID->"7942554b-91c6-4f01-a8db-8346ed5895f5"],
Cell[313038, 5391, 5600, 135, 90, "Output",ExpressionUUID->"812b04b9-03b8-481a-bc9f-94e36c04af64"]
}, Open  ]],
Cell[CellGroupData[{
Cell[318675, 5531, 4116, 64, 45, "Input",ExpressionUUID->"f2296a22-1539-4b87-9893-cb5272d3e72d"],
Cell[322794, 5597, 4060, 74, 52, "Output",ExpressionUUID->"f6ae244b-d1f6-4331-8e91-4f07c83f47a9"]
}, Open  ]],
Cell[326869, 5674, 173, 2, 28, "Input",ExpressionUUID->"ed1965d8-a8ad-4199-9b19-fd3d8aa9eb69"],
Cell[CellGroupData[{
Cell[327067, 5680, 491, 10, 48, "Input",ExpressionUUID->"7c70b767-8c9b-4f20-879c-7bd0727a2e04"],
Cell[327561, 5692, 773, 11, 32, "Output",ExpressionUUID->"5b1bf943-6b2a-4b7c-b746-5afc7eda8a38"]
}, Open  ]],
Cell[328349, 5706, 168, 2, 48, "Input",ExpressionUUID->"cef719fa-f11d-4fe1-a4e7-592012787a23"],
Cell[328520, 5710, 166, 2, 48, "Input",ExpressionUUID->"18acbb10-fe28-49c2-956d-797c010a0202"],
Cell[328689, 5714, 266, 5, 28, "Input",ExpressionUUID->"bc177c88-4747-44cb-8140-9e733d4f12a4"],
Cell[CellGroupData[{
Cell[328980, 5723, 662, 13, 82, "Input",ExpressionUUID->"a1e86622-e126-4889-828b-21f41dc743d1"],
Cell[329645, 5738, 4099, 67, 130, "Output",ExpressionUUID->"e56bf5f9-8a11-40b2-9e3e-347b372b5e45"]
}, Open  ]],
Cell[CellGroupData[{
Cell[333781, 5810, 214, 3, 45, "Input",ExpressionUUID->"baea1906-037e-4960-8e2a-d549803f3ce8"],
Cell[333998, 5815, 2360, 32, 32, "Output",ExpressionUUID->"de1d6ba5-3d1c-4e0b-ae64-916e983bec79"]
}, Open  ]],
Cell[CellGroupData[{
Cell[336395, 5852, 763, 12, 82, "Input",ExpressionUUID->"9cf435ce-a2a9-4500-ab13-18854018a4ff"],
Cell[337161, 5866, 6324, 97, 66, "Output",ExpressionUUID->"f9e03699-bc47-40e0-b59d-e3a1852c509b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[343522, 5968, 545, 16, 45, "Input",ExpressionUUID->"50cdf8e5-0505-4ced-8bf2-d6b697d1e691"],
Cell[344070, 5986, 1907, 44, 52, "Output",ExpressionUUID->"10ece405-1866-4168-89a9-596429252861"]
}, Open  ]],
Cell[345992, 6033, 226, 3, 28, "Input",ExpressionUUID->"b1707b3e-5578-4766-8b7a-0f0e751f7a83"],
Cell[CellGroupData[{
Cell[346243, 6040, 1177, 30, 103, "Input",ExpressionUUID->"e0e02068-08af-490f-8587-42f223fc6c58"],
Cell[347423, 6072, 5218, 110, 105, "Output",ExpressionUUID->"373c249d-2c09-468b-8bfc-f1f4e900230f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[352678, 6187, 8459, 172, 404, "Input",ExpressionUUID->"73b2bc27-aed3-4487-8404-b582c029773d"],
Cell[361140, 6361, 5298, 100, 98, "Output",ExpressionUUID->"dd97b30a-db94-4715-909a-9903111761c6"]
}, Open  ]],
Cell[366453, 6464, 200, 3, 28, "Input",ExpressionUUID->"0e32202b-72b6-4320-bf4e-417dfb2a4cc0"],
Cell[CellGroupData[{
Cell[366678, 6471, 5691, 93, 82, "Input",ExpressionUUID->"82b85410-2586-45fa-bafa-b76c161994b9"],
Cell[372372, 6566, 2430, 44, 32, "Output",ExpressionUUID->"05b8224e-6e14-4a7a-96ee-cdf6ee2ac580"],
Cell[374805, 6612, 2833, 58, 52, "Output",ExpressionUUID->"1b875078-830a-4c8f-b3d9-e322acca3cdd"]
}, Open  ]],
Cell[377653, 6673, 1443, 38, 141, "Input",ExpressionUUID->"9e8bb089-05d0-49cd-a591-a76a8f40dade"],
Cell[CellGroupData[{
Cell[379121, 6715, 173, 2, 28, "Input",ExpressionUUID->"7c4d0961-cfbb-414d-8556-4aa58b88f48e"],
Cell[379297, 6719, 1493, 25, 32, "Output",ExpressionUUID->"0cbed928-88bd-458d-af5d-bf5b3b5ffc98"]
}, Open  ]],
Cell[380805, 6747, 173, 2, 28, "Input",ExpressionUUID->"3b189ba1-c781-43e1-a610-dd1dfa75fbd2"],
Cell[CellGroupData[{
Cell[381003, 6753, 767, 18, 45, "Input",ExpressionUUID->"746d21ba-082b-4829-92e8-8cf178eae08f"],
Cell[381773, 6773, 4205, 72, 52, "Output",ExpressionUUID->"5b87b25f-610d-4cbd-9d35-567681978d84"]
}, Open  ]],
Cell[385993, 6848, 290, 6, 28, "Input",ExpressionUUID->"9a754de6-bb99-4733-bb31-05aa3bcf54b3"],
Cell[386286, 6856, 166, 2, 48, "Input",ExpressionUUID->"97363c80-4e6c-4d96-a806-a1f33a87b2e0"],
Cell[CellGroupData[{
Cell[386477, 6862, 811, 21, 86, "Input",ExpressionUUID->"ff47a490-5502-40e1-94c1-d9afe9009c70"],
Cell[387291, 6885, 658, 9, 32, "Output",ExpressionUUID->"5c6c9f0e-d574-4a29-8628-b0c12c483979"],
Cell[387952, 6896, 658, 9, 32, "Output",ExpressionUUID->"93f80741-c84d-4de8-8a81-726918e9c69d"]
}, Open  ]],
Cell[388625, 6908, 173, 2, 56, "Input",ExpressionUUID->"da54a4d8-a594-4f58-b121-e8c887b1d2bb"]
}
]
*)

